/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang;

import java.util.Optional;
import java.util.function.Consumer;

public enum Trivalent {
    UNKNOWN{

        @Override
        public Trivalent and(boolean right) {
            return right ? UNKNOWN : FALSE;
        }

        @Override
        public Trivalent or(boolean right) {
            return right ? TRUE : UNKNOWN;
        }

        @Override
        public Trivalent and(Trivalent right) {
            return right == FALSE ? FALSE : UNKNOWN;
        }

        @Override
        public Trivalent or(Trivalent right) {
            return right == TRUE ? TRUE : UNKNOWN;
        }

        @Override
        public Trivalent negation() {
            return UNKNOWN;
        }

        @Override
        public Optional<Boolean> toBoolean() {
            return Optional.empty();
        }

        @Override
        public boolean asBoolean() {
            throw new ClassCastException("Trivalent.UNKNOWN::asBoolean");
        }
    }
    ,
    FALSE{

        @Override
        public Trivalent and(boolean right) {
            return FALSE;
        }

        @Override
        public Trivalent or(boolean right) {
            return right ? TRUE : FALSE;
        }

        @Override
        public Trivalent and(Trivalent right) {
            return FALSE;
        }

        @Override
        public Trivalent or(Trivalent right) {
            return right;
        }

        @Override
        public Trivalent negation() {
            return TRUE;
        }

        @Override
        public Optional<Boolean> toBoolean() {
            return OPTIONAL_FALSE;
        }

        @Override
        public boolean asBoolean() {
            return false;
        }
    }
    ,
    TRUE{

        @Override
        public Trivalent and(boolean right) {
            return right ? TRUE : FALSE;
        }

        @Override
        public Trivalent or(boolean right) {
            return TRUE;
        }

        @Override
        public Trivalent and(Trivalent right) {
            return right;
        }

        @Override
        public Trivalent or(Trivalent right) {
            return TRUE;
        }

        @Override
        public Trivalent negation() {
            return FALSE;
        }

        @Override
        public Optional<Boolean> toBoolean() {
            return OPTIONAL_TRUE;
        }

        @Override
        public boolean asBoolean() {
            return true;
        }
    };

    static final Optional<Boolean> OPTIONAL_FALSE;
    static final Optional<Boolean> OPTIONAL_TRUE;

    public abstract Trivalent and(Trivalent var1);

    public abstract Trivalent or(Trivalent var1);

    public Trivalent and(Boolean right) {
        return this.and(Trivalent.fromBoolean(right));
    }

    public Trivalent or(Boolean right) {
        return this.or(Trivalent.fromBoolean(right));
    }

    public abstract Trivalent and(boolean var1);

    public abstract Trivalent or(boolean var1);

    public abstract Trivalent negation();

    public abstract Optional<Boolean> toBoolean();

    public final boolean isTrue() {
        return this == TRUE;
    }

    public final boolean isFalse() {
        return this == FALSE;
    }

    public final boolean isUnknown() {
        return this == UNKNOWN;
    }

    public final boolean isBoolean() {
        return this != UNKNOWN;
    }

    public final Trivalent ifTrue(Runnable action) {
        if (this.isTrue()) {
            action.run();
        }
        return this;
    }

    public final Trivalent ifFalse(Runnable action) {
        if (this.isFalse()) {
            action.run();
        }
        return this;
    }

    public final Trivalent ifUnknown(Runnable action) {
        if (this.isUnknown()) {
            action.run();
        }
        return this;
    }

    public final Trivalent ifBoolean(Consumer<? super Boolean> action) {
        if (this.isBoolean()) {
            action.accept((Boolean)this.asBoolean());
        }
        return this;
    }

    public abstract boolean asBoolean();

    public static Trivalent fromBoolean(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static Trivalent fromBoolean(Boolean value) {
        return value == null ? UNKNOWN : Trivalent.fromBoolean((boolean)value);
    }

    static {
        OPTIONAL_FALSE = Optional.of(Boolean.FALSE);
        OPTIONAL_TRUE = Optional.of(Boolean.TRUE);
    }
}

