/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Objects;

public class TypeToken<T> {
    private final Type type;
    private final Class<?> runtimeClass;

    protected TypeToken() {
        this.type = TypeToken.typeArgument(this.getClass(), TypeToken.class);
        this.runtimeClass = TypeToken.typeClass(this.type);
    }

    public TypeToken(Type genericType) {
        this.type = Objects.requireNonNull(genericType);
        this.runtimeClass = TypeToken.typeClass(this.type);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof TypeToken && this.type.equals(((TypeToken)obj).type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public final String toString() {
        return String.format("TypeToken[%s]", this.type);
    }

    public final Type type() {
        return this.type;
    }

    @Deprecated
    public final Class<?> raw() {
        return this.runtimeClass;
    }

    public final Class<?> runtimeClass() {
        return this.runtimeClass;
    }

    public final Class<T> nominalClass() {
        return this.runtimeClass;
    }

    private static Class<?> typeClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (parameterizedType.getRawType() instanceof Class) {
                return (Class)parameterizedType.getRawType();
            }
        } else if (type instanceof GenericArrayType) {
            GenericArrayType array = (GenericArrayType)type;
            Class<?> componentRawType = TypeToken.typeClass(array.getGenericComponentType());
            return TypeToken.arrayClass(componentRawType);
        }
        String f = "Type parameter '%s' is not a class or a parametrized type whose raw type is a class.";
        throw new IllegalArgumentException(String.format("Type parameter '%s' is not a class or a parametrized type whose raw type is a class.", type));
    }

    private static Class<?> arrayClass(Class<?> component) {
        try {
            return Array.newInstance(component, 0).getClass();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Type typeArgument(Class<?> clazz, Class<?> base) {
        ParameterizedType pt;
        Class rt;
        int argIndex;
        Type currentType;
        ArrayDeque<Type> superClasses = new ArrayDeque<Type>();
        Class currentClass = clazz;
        do {
            currentType = currentClass.getGenericSuperclass();
            superClasses.push(currentType);
            if (currentType instanceof Class) {
                currentClass = (Class)currentType;
                continue;
            }
            if (!(currentType instanceof ParameterizedType)) continue;
            currentClass = (Class)((ParameterizedType)currentType).getRawType();
        } while (!currentClass.equals(base));
        TypeVariable tv = base.getTypeParameters()[0];
        while (!superClasses.isEmpty() && (currentType = (Type)superClasses.pop()) instanceof ParameterizedType && 0 <= (argIndex = Arrays.asList((rt = (Class)(pt = (ParameterizedType)currentType).getRawType()).getTypeParameters()).indexOf(tv))) {
            Type typeArg = pt.getActualTypeArguments()[argIndex];
            if (typeArg instanceof TypeVariable) {
                tv = (TypeVariable)typeArg;
                continue;
            }
            return typeArg;
        }
        String f = "Type '%s' does not specify the generic type parameter.";
        throw new IllegalArgumentException(String.format("Type '%s' does not specify the generic type parameter.", currentType));
    }
}

