/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.closeables;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.yetamine.lang.closeables.PureCloseable;
import net.yetamine.lang.closeables.ResourceClosing;
import net.yetamine.lang.closeables.ResourceHandle;
import net.yetamine.lang.closeables.ResourceOpening;

public final class ResourceAdapter<R, X extends Exception>
implements ResourceHandle<R, X> {
    private final ResourceClosing<? super R, ? extends X> closing;
    private final ResourceClosing<? super R, ? extends X> releasing;
    private ResourceOpening<? extends R, ? extends X> opening;
    private volatile R instance;

    private ResourceAdapter(ResourceOpening<? extends R, ? extends X> constructor, ResourceClosing<? super R, ? extends X> destructor) {
        this.opening = Objects.requireNonNull(constructor);
        Objects.requireNonNull(destructor);
        this.closing = r -> {
            if (r != null) {
                destructor.close(r);
            }
        };
        this.releasing = this.closing;
    }

    private ResourceAdapter(R resource, ResourceClosing<? super R, ? extends X> destructor, Void nil) {
        Objects.requireNonNull(destructor);
        AtomicBoolean closed = new AtomicBoolean();
        this.closing = r -> {
            assert (r == null || r == resource);
            if (closed.compareAndSet(false, true) && resource != null) {
                destructor.close((Object)resource);
            }
        };
        this.instance = resource;
        this.opening = () -> resource;
        this.releasing = ResourceClosing.none();
    }

    public static <R, X extends Exception> ResourceHandle<R, X> managed(ResourceOpening<? extends R, ? extends X> constructor, ResourceClosing<? super R, ? extends X> destructor) {
        return new ResourceAdapter<R, X>(constructor, destructor);
    }

    public static <X extends Exception, R extends PureCloseable<? extends X>> ResourceHandle<R, X> managed(ResourceOpening<? extends R, ? extends X> constructor) {
        return ResourceAdapter.managed(constructor, r -> r.close());
    }

    public static <R, X extends Exception> ResourceHandle<R, X> adopted(R resource, ResourceClosing<? super R, ? extends X> destructor) {
        return new ResourceAdapter<R, X>(resource, destructor, null);
    }

    public static <X extends Exception, R extends PureCloseable<? extends X>> ResourceHandle<R, X> adopted(R resource) {
        return ResourceAdapter.adopted(resource, r -> r.close());
    }

    public static <R, X extends Exception> ResourceHandle<R, X> using(R resource) {
        return ResourceAdapter.adopted(resource, ResourceClosing.none());
    }

    public String toString() {
        return String.format("ResourceHandle[id=%08x, instance=%s]", System.identityHashCode(this), this.instance);
    }

    @Override
    public Optional<R> available() {
        return Optional.ofNullable(this.instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R acquired() throws X {
        R result = this.instance;
        if (result != null) {
            return result;
        }
        ResourceAdapter resourceAdapter = this;
        synchronized (resourceAdapter) {
            result = this.instance;
            if (result != null) {
                return result;
            }
            if (this.opening == null) {
                throw new IllegalStateException();
            }
            this.instance = result = this.opening.open();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() throws X {
        R resource;
        ResourceAdapter resourceAdapter = this;
        synchronized (resourceAdapter) {
            resource = this.instance;
            this.instance = null;
        }
        this.releasing.close(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws X {
        R resource;
        ResourceAdapter resourceAdapter = this;
        synchronized (resourceAdapter) {
            this.opening = null;
            resource = this.instance;
            this.instance = null;
        }
        this.closing.close(resource);
    }
}

