/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.closeables;

import java.util.Arrays;
import net.yetamine.lang.exceptions.Throwing;

@FunctionalInterface
public interface ResourceClosing<R, X extends Exception> {
    public void close(R var1) throws X;

    default public void closeAll(R ... objects) throws X {
        this.closeAll((Iterable<? extends R>)Arrays.asList(objects));
    }

    default public void closeAll(Iterable<? extends R> objects) throws X {
        Throwable exception = null;
        for (R object : objects) {
            if (object == null) continue;
            try {
                this.close(object);
            }
            catch (Throwable t) {
                if (exception == null) {
                    exception = t;
                    continue;
                }
                exception.addSuppressed(t);
            }
        }
        if (exception == null) {
            return;
        }
        Throwing.some(exception).throwIfUnchecked();
        Exception throwable = (Exception)exception;
        throw throwable;
    }

    public static <R, X extends Exception> ResourceClosing<R, X> from(ResourceClosing<? super R, ? extends X> closing) {
        return closing;
    }

    public static <R, X extends Exception> ResourceClosing<R, X> none() {
        return r -> {};
    }
}

