/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.closeables;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

@FunctionalInterface
public interface ResourceOpening<R, X extends Exception> {
    public R open() throws X;

    public static <R, X extends Exception> ResourceOpening<R, X> once(ResourceOpening<? extends R, ? extends X> opening, Supplier<? extends X> exception) {
        Objects.requireNonNull(exception);
        Objects.requireNonNull(opening);
        AtomicBoolean used = new AtomicBoolean();
        return () -> {
            if (used.compareAndSet(false, true)) {
                return opening.open();
            }
            throw (Exception)exception.get();
        };
    }
}

