/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.closeables;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.yetamine.lang.closeables.ResourceClosing;
import net.yetamine.lang.closeables.ResourceGroup;
import net.yetamine.lang.closeables.ResourceHandle;
import net.yetamine.lang.closeables.ResourceOpening;
import net.yetamine.lang.exceptions.Throwing;

public final class ResourcePile<X extends Exception>
implements ResourceGroup<X> {
    private final Handle<?, X> root = new Handle();
    private boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> ResourceHandle<R, X> managed(ResourceOpening<? extends R, ? extends X> constructor, ResourceClosing<? super R, ? extends X> destructor) {
        Handle<?, X> handle = this.root;
        synchronized (handle) {
            if (this.closed) {
                throw new IllegalStateException();
            }
            Handle<? super R, ? extends X> result = new Handle<R, X>(this.root, constructor, destructor);
            this.root.append(result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> ResourceHandle<R, X> adopted(R resource, ResourceClosing<? super R, ? extends X> destructor) {
        Handle<?, X> handle = this.root;
        synchronized (handle) {
            if (this.closed) {
                throw new IllegalStateException();
            }
            Handle<? super R, ? extends X> result = new Handle<R, X>(this.root, resource, destructor, null);
            this.root.append(result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() throws X {
        Throwable exception = null;
        boolean interrupt = false;
        Handle<?, X> handle = this.root;
        synchronized (handle) {
            for (Handle<?, X> handle2 = this.root.next(); handle2 != this.root; handle2 = handle2.next()) {
                try {
                    handle2.release();
                    continue;
                }
                catch (Throwable t) {
                    if (exception == null) {
                        exception = t;
                        continue;
                    }
                    interrupt |= t instanceof InterruptedException;
                    exception.addSuppressed(t);
                }
            }
        }
        ResourcePile.rethrow(exception, interrupt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws X {
        Throwable exception = null;
        boolean interrupt = false;
        Handle<?, X> handle = this.root;
        synchronized (handle) {
            Handle<?, X> handle2;
            this.closed = true;
            while ((handle2 = this.root.removeNext()) != this.root) {
                try {
                    handle2.close();
                }
                catch (Throwable t) {
                    if (exception == null) {
                        exception = t;
                        continue;
                    }
                    interrupt |= t instanceof InterruptedException;
                    exception.addSuppressed(t);
                }
            }
        }
        ResourcePile.rethrow(exception, interrupt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean closed() {
        Handle<?, X> handle = this.root;
        synchronized (handle) {
            return this.closed;
        }
    }

    private static <X extends Throwable> void rethrow(Throwable exception, boolean interrupt) throws X {
        if (exception == null) {
            return;
        }
        Throwing.some(exception).throwIfUnchecked();
        if (interrupt && !(exception instanceof InterruptedException)) {
            Thread.currentThread().interrupt();
        }
        Throwable throwable = exception;
        throw throwable;
    }

    private static final class Handle<R, X extends Exception>
    implements ResourceHandle<R, X> {
        private final Handle<?, X> root;
        private Handle<?, X> prev = this;
        private Handle<?, X> next = this;
        private final ResourceClosing<? super R, ? extends X> closing;
        private final ResourceClosing<? super R, ? extends X> releasing;
        private ResourceOpening<? extends R, ? extends X> opening;
        private volatile R instance;

        Handle() {
            this.releasing = ResourceClosing.none();
            this.closing = this.releasing;
            this.opening = null;
            this.root = this;
        }

        Handle(Handle<?, X> head, ResourceOpening<? extends R, ? extends X> constructor, ResourceClosing<? super R, ? extends X> destructor) {
            this.opening = Objects.requireNonNull(constructor);
            Objects.requireNonNull(destructor);
            this.closing = r -> {
                if (r != null) {
                    destructor.close(r);
                }
            };
            this.releasing = this.closing;
            this.root = head;
            assert (this.root != null);
        }

        Handle(Handle<?, X> head, R resource, ResourceClosing<? super R, ? extends X> destructor, Void nil) {
            Objects.requireNonNull(destructor);
            AtomicBoolean closed = new AtomicBoolean();
            this.closing = r -> {
                assert (r == null || r == resource);
                if (closed.compareAndSet(false, true) && resource != null) {
                    destructor.close((Object)resource);
                }
            };
            this.releasing = ResourceClosing.none();
            this.opening = () -> resource;
            this.instance = resource;
            this.root = head;
            assert (this.root != null);
        }

        public String toString() {
            return String.format("ResourceHandle[id=%08x, instance=%s]", System.identityHashCode(this), this.instance);
        }

        @Override
        public Optional<R> available() {
            return Optional.ofNullable(this.instance);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public R acquired() throws X {
            R result = this.instance;
            if (result != null) {
                return result;
            }
            Handle handle = this;
            synchronized (handle) {
                result = this.instance;
                if (result != null) {
                    return result;
                }
                if (this.opening == null) {
                    throw new IllegalStateException();
                }
                this.instance = result = this.opening.open();
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() throws X {
            R resource;
            Handle handle = this;
            synchronized (handle) {
                resource = this.instance;
                this.instance = null;
            }
            this.releasing.close(resource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws X {
            R resource;
            Handle<?, X> handle = this.root;
            synchronized (handle) {
                this.removeSelf();
            }
            Handle handle2 = this;
            synchronized (handle2) {
                resource = this.instance;
                this.instance = null;
                this.opening = null;
            }
            this.closing.close(resource);
        }

        void append(Handle<?, X> handle) {
            assert (Thread.holdsLock(this.root));
            handle.next = this.next;
            this.next.prev = handle;
            handle.prev = this;
            this.next = handle;
        }

        Handle<?, X> removeNext() {
            assert (Thread.holdsLock(this.root));
            Handle<?, X> result = this.next;
            result.removeSelf();
            return result;
        }

        void removeSelf() {
            assert (Thread.holdsLock(this.root));
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.prev = this.next = this;
        }

        Handle<?, X> next() {
            return this.next;
        }
    }
}

