/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.function.Function;

public final class Capture {
    private Capture() {
        throw new AssertionError();
    }

    public static <E> Set<E> frozen(Set<? extends E> source) {
        if (source.isEmpty()) {
            return Collections.emptySet();
        }
        Iterator<E> it = source.iterator();
        E head = it.next();
        return it.hasNext() ? Collections.unmodifiableSet(source) : Collections.singleton(head);
    }

    public static <E> List<E> frozen(List<? extends E> source) {
        if (source.isEmpty()) {
            return Collections.emptyList();
        }
        return source.size() == 1 ? Collections.singletonList(source.get(0)) : Collections.unmodifiableList(source);
    }

    public static <K, V> Map<K, V> frozen(Map<? extends K, ? extends V> source) {
        if (source.isEmpty()) {
            return Collections.emptyMap();
        }
        Iterator<Map.Entry<K, V>> it = source.entrySet().iterator();
        Map.Entry<K, V> head = it.next();
        if (it.hasNext()) {
            return Collections.unmodifiableMap(source);
        }
        return Collections.singletonMap(head.getKey(), head.getValue());
    }

    public static <E, C extends Collection<? extends E>> Set<E> set(C source, Function<? super C, ? extends Set<? extends E>> transformation) {
        if (source.isEmpty()) {
            return Collections.emptySet();
        }
        Set<E> result = transformation.apply(source);
        Set<E> unmodifiable = Collections.unmodifiableSet(result);
        return result.getClass() == unmodifiable.getClass() ? result : unmodifiable;
    }

    public static <E> Set<E> set(Collection<? extends E> source) {
        return Capture.set(source, HashSet::new);
    }

    public static <E, C extends Collection<? extends E>> NavigableSet<E> navigableSet(C source, Function<? super C, ? extends NavigableSet<E>> transformation) {
        if (source.isEmpty()) {
            return Collections.emptyNavigableSet();
        }
        NavigableSet<E> result = transformation.apply(source);
        NavigableSet<E> unmodifiable = Collections.unmodifiableNavigableSet(result);
        return result.getClass() == unmodifiable.getClass() ? result : unmodifiable;
    }

    public static <E, C extends Collection<? extends E>> SortedSet<E> sortedSet(C source, Function<? super C, ? extends SortedSet<E>> transformation) {
        if (source.isEmpty()) {
            return Collections.emptySortedSet();
        }
        SortedSet<E> result = transformation.apply(source);
        SortedSet<E> unmodifiable = Collections.unmodifiableSortedSet(result);
        return result.getClass() == unmodifiable.getClass() ? result : unmodifiable;
    }

    public static <E, C extends Collection<? extends E>> List<E> list(C source, Function<? super C, ? extends List<? extends E>> transformation) {
        if (source.isEmpty()) {
            return Collections.emptyList();
        }
        List<E> result = transformation.apply(source);
        List<E> unmodifiable = Collections.unmodifiableList(result);
        return result.getClass() == unmodifiable.getClass() ? result : unmodifiable;
    }

    public static <E> List<E> list(Collection<? extends E> source) {
        return Capture.list(source, ArrayList::new);
    }

    public static <K, V, M extends Map<? extends K, ? extends V>> Map<K, V> map(M source, Function<? super M, ? extends Map<? extends K, ? extends V>> transformation) {
        if (source.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<K, V> result = transformation.apply(source);
        Map<K, V> unmodifiable = Collections.unmodifiableMap(result);
        return result.getClass() == unmodifiable.getClass() ? result : unmodifiable;
    }

    public static <K, V> Map<K, V> map(Map<? extends K, ? extends V> source) {
        return Capture.map(source, HashMap::new);
    }

    public static <K, V, M extends NavigableMap<? extends K, ? extends V>> NavigableMap<K, V> navigableMap(M source, Function<? super M, ? extends NavigableMap<K, V>> transformation) {
        if (source.isEmpty()) {
            return Collections.emptyNavigableMap();
        }
        NavigableMap<K, V> result = transformation.apply(source);
        NavigableMap<K, V> unmodifiable = Collections.unmodifiableNavigableMap(result);
        return result.getClass() == unmodifiable.getClass() ? result : unmodifiable;
    }

    public static <K, V, M extends SortedMap<? extends K, ? extends V>> SortedMap<K, V> sortedMap(M source, Function<? super M, ? extends SortedMap<K, V>> transformation) {
        if (source.isEmpty()) {
            return Collections.emptySortedMap();
        }
        SortedMap<K, V> result = transformation.apply(source);
        SortedMap<K, V> unmodifiable = Collections.unmodifiableSortedMap(result);
        return result.getClass() == unmodifiable.getClass() ? result : unmodifiable;
    }
}

