/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.collections;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Objects;

@FunctionalInterface
public interface IteratorAsEnumeration<E>
extends Enumeration<E> {
    public Iterator<? extends E> iterator();

    @Override
    default public boolean hasMoreElements() {
        return this.iterator().hasNext();
    }

    @Override
    default public E nextElement() {
        return this.iterator().next();
    }

    public static <E> IteratorAsEnumeration<E> from(Iterator<? extends E> iterator) {
        Objects.requireNonNull(iterator);
        return () -> iterator;
    }
}

