/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.collections;

import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.yetamine.lang.collections.EmptyMapping;
import net.yetamine.lang.collections.MappingAdapter;

public interface Mapping<K, V> {
    public static <K, V> Mapping<K, V> empty() {
        return EmptyMapping.INSTANCE.cast();
    }

    public static <K, V> Mapping<K, V> adapting(Map<K, V> map) {
        return new MappingAdapter<K, V>(map);
    }

    public V get(Object var1);

    default public V getOrDefault(Object key, V defaultValue) {
        V result = this.get(key);
        return result != null ? result : defaultValue;
    }

    default public V getOrProvide(Object key, Supplier<? extends V> provider) {
        V result = this.get(key);
        return result != null ? result : provider.get();
    }

    default public Optional<V> find(Object key) {
        return Optional.ofNullable(this.get(key));
    }

    public V put(K var1, V var2);

    public V putIfAbsent(K var1, V var2);

    default public V let(K key, V value) {
        return value != null ? this.put(key, value) : this.remove(key);
    }

    public V replace(K var1, V var2);

    public boolean replace(K var1, V var2, V var3);

    public void clear();

    public V remove(Object var1);

    public boolean remove(Object var1, Object var2);

    public V merge(K var1, V var2, BiFunction<? super V, ? super V, ? extends V> var3);

    public V compute(K var1, BiFunction<? super K, ? super V, ? extends V> var2);

    public V computeIfAbsent(K var1, Function<? super K, ? extends V> var2);

    public V computeIfPresent(K var1, BiFunction<? super K, ? super V, ? extends V> var2);

    default public V supplyIfAbsent(K key, Supplier<? extends V> valueSupplier) {
        return (V)this.computeIfAbsent(key, k -> valueSupplier.get());
    }

    default public V supplyIfPresent(K key, Supplier<? extends V> valueSupplier) {
        return (V)this.computeIfPresent(key, (k, v) -> valueSupplier.get());
    }
}

