/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.collections;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.yetamine.lang.collections.Mapping;

final class MappingAdapter<K, V>
implements Serializable,
Mapping<K, V> {
    private static final long serialVersionUID = 1L;
    private final Map<K, V> map;

    public MappingAdapter(Map<K, V> storage) {
        this.map = Objects.requireNonNull(storage);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.map.put(key, value);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.map.putIfAbsent(key, value);
    }

    @Override
    public V replace(K key, V value) {
        return this.map.replace(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.map.replace(key, oldValue, newValue);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.map.remove(key, value);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remapping) {
        return this.map.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remapping);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remapping) {
        return this.map.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remapping);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mapping) {
        return this.map.computeIfAbsent((K)key, mapping);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remapping) {
        return this.map.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remapping);
    }
}

