/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.concurrent;

import java.util.Objects;
import java.util.concurrent.locks.Lock;
import net.yetamine.lang.closeables.SafeCloseable;

public final class LockRegion
implements SafeCloseable {
    private Lock lock;

    private LockRegion(Lock l) {
        this.lock = Objects.requireNonNull(l);
    }

    public static LockRegion open(Lock lock) {
        LockRegion result = new LockRegion(lock);
        lock.lock();
        return result;
    }

    public static LockRegion openInterruptibly(Lock lock) throws InterruptedException {
        LockRegion result = new LockRegion(lock);
        lock.lockInterruptibly();
        return result;
    }

    public boolean locked() {
        return this.lock != null;
    }

    @Override
    public void close() {
        if (this.lock != null) {
            this.lock.unlock();
            this.lock = null;
        }
    }
}

