/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.concurrent;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import net.yetamine.lang.concurrent.Interruptible;

public final class SynchronousExecutorService
extends AbstractExecutorService
implements Interruptible {
    private final Map<Thread, Long> running = new HashMap<Thread, Long>();
    private boolean shutdown;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable command) {
        Objects.requireNonNull(command);
        Thread currentThread = Thread.currentThread();
        Map<Thread, Long> map = this.running;
        synchronized (map) {
            if (this.shutdown) {
                throw new RejectedExecutionException("Executor shut down.");
            }
            this.running.compute(currentThread, (t, v) -> v != null ? v + 1L : 1L);
        }
        try {
            command.run();
        }
        finally {
            map = this.running;
            synchronized (map) {
                this.running.compute(currentThread, (t, v) -> v == 1L ? null : Long.valueOf(v - 1L));
                if (this.shutdown && this.running.isEmpty()) {
                    this.running.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Map<Thread, Long> map = this.running;
        synchronized (map) {
            this.shutdown = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        Map<Thread, Long> map = this.running;
        synchronized (map) {
            if (!this.shutdown) {
                this.shutdown = true;
                this.running.keySet().forEach(Thread::interrupt);
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isShutdown() {
        Map<Thread, Long> map = this.running;
        synchronized (map) {
            return this.shutdown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminated() {
        Map<Thread, Long> map = this.running;
        synchronized (map) {
            return this.shutdown && this.running.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long remaining = unit.toNanos(timeout);
        long timestamp = System.nanoTime();
        Map<Thread, Long> map = this.running;
        synchronized (map) {
            while (!this.shutdown || !this.running.isEmpty()) {
                if (remaining <= 0L) {
                    return false;
                }
                TimeUnit.NANOSECONDS.timedWait(this.running, remaining);
                remaining -= System.nanoTime() - timestamp;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interrupt() {
        Map<Thread, Long> map = this.running;
        synchronized (map) {
            this.running.keySet().forEach(Thread::interrupt);
        }
    }
}

