/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.containers;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.yetamine.lang.containers.Pointer;

final class DefaultPointer<T>
implements Pointer<T> {
    private final Supplier<? extends T> supplier;
    private final Consumer<? super T> consumer;

    public DefaultPointer(Supplier<? extends T> source, Consumer<? super T> target) {
        this.supplier = Objects.requireNonNull(source);
        this.consumer = Objects.requireNonNull(target);
    }

    public String toString() {
        return String.format("pointer[%s]", this.get());
    }

    @Override
    public T get() {
        return this.supplier.get();
    }

    @Override
    public void accept(T t) {
        this.consumer.accept(t);
    }
}

