/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.containers;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.yetamine.lang.containers.DefaultPointer;
import net.yetamine.lang.functional.Producer;

public interface Pointer<T>
extends Consumer<T>,
Producer<T> {
    public static <T> Pointer<T> from(Supplier<? extends T> supplier, Consumer<? super T> consumer) {
        return new DefaultPointer<T>(supplier, consumer);
    }

    @Override
    public T get();

    @Override
    public void accept(T var1);

    default public void swap(Pointer<T> other) {
        T t = other.get();
        other.accept(this.get());
        this.accept(t);
    }

    default public T compute(Function<? super T, ? extends T> mapping) {
        T result = mapping.apply(this.get());
        this.accept(result);
        return result;
    }

    default public T compute(BiFunction<? super T, ? super T, ? extends T> mapping, T value) {
        T result = mapping.apply(value, this.get());
        this.accept(result);
        return result;
    }
}

