/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.containers.bytes;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.stream.IntStream;
import net.yetamine.lang.containers.bytes.ByteContainer;
import net.yetamine.lang.containers.bytes.ByteSequence;
import net.yetamine.lang.containers.bytes.ByteSequences;

public final class ByteArrayView
implements ByteSequence {
    private final byte[] array;
    private final int origin;
    private final int length;
    private ByteBuffer buffer;
    private volatile int hashCode;

    private ByteArrayView(byte[] data, int from, int count) {
        this.array = data;
        this.origin = from;
        this.length = count;
        assert (this.length > 0);
    }

    private ByteArrayView(byte[] data, int from, int count, Void overload) {
        this(data, from, count);
        this.hashCode = Integer.MIN_VALUE;
    }

    public static ByteSequence view(byte ... data) {
        return data.length == 0 ? ByteSequence.empty() : new ByteArrayView(data, 0, data.length, null);
    }

    public static ByteSequence view(byte[] data, int from, int to) {
        int length = ByteSequences.length(from, to, data.length);
        return length == 0 ? ByteSequence.empty() : new ByteArrayView(data, from, length, null);
    }

    public static ByteSequence from(int ... data) {
        return ByteContainer.from(data);
    }

    public static ByteSequence of(byte ... data) {
        return data.length == 0 ? ByteSequence.empty() : new ByteArrayView(data, 0, data.length);
    }

    public static ByteSequence of(byte[] data, int from, int to) {
        int length = ByteSequences.length(from, to, data.length);
        return length == 0 ? ByteSequence.empty() : new ByteArrayView(data, from, length);
    }

    @Override
    public String toString() {
        return ByteSequences.toString(this);
    }

    @Override
    public boolean equals(Object obj) {
        return ByteSequences.equals(this, obj);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == Integer.MIN_VALUE) {
            return ByteSequences.hashCode(this);
        }
        if (result == 0) {
            this.hashCode = result = ByteSequences.hashCode(this);
        }
        return result;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public byte valueAt(int index) {
        return this.array[this.origin + ByteSequences.index(index, 0 <= index && index < this.length)];
    }

    @Override
    public ByteContainer copy(int from, int to) {
        return ByteContainer.of(this.array, this.origin + from, this.origin + to);
    }

    @Override
    public ByteSequence view(int from, int to) {
        int range = ByteSequences.length(from, to, this.length);
        return range == 0 ? ByteSequence.empty() : new ByteArrayView(this.array, this.origin + from, range);
    }

    @Override
    public byte[] array() {
        byte[] result = new byte[this.length];
        System.arraycopy(this.array, this.origin, result, 0, this.length);
        return result;
    }

    @Override
    public byte[] array(int from, int to) {
        int range = ByteSequences.length(from, to, this.length);
        if (range == 0) {
            return ByteSequence.empty().array();
        }
        byte[] result = new byte[range];
        System.arraycopy(this.array, this.origin, result, 0, range);
        return result;
    }

    @Override
    public String string(Charset encoding) {
        return new String(this.array, this.origin, this.length, encoding);
    }

    @Override
    public ByteBuffer buffer() {
        ByteBuffer result = this.buffer;
        if (result == null) {
            this.buffer = result = ByteBuffer.wrap(this.array, this.origin, this.length).slice();
        }
        return result.asReadOnlyBuffer();
    }

    @Override
    public IntStream stream() {
        return IntStream.range(this.origin, this.origin + this.length).map(i -> this.array[i]);
    }
}

