/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.containers.bytes;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.stream.IntStream;
import net.yetamine.lang.containers.bytes.ByteContainer;
import net.yetamine.lang.containers.bytes.ByteSequence;
import net.yetamine.lang.containers.bytes.ByteSequences;
import net.yetamine.lang.exceptions.Throwables;

public final class ByteBufferView
implements ByteSequence {
    private final ByteBuffer buffer;
    private volatile int hashCode;

    private ByteBufferView(ByteBuffer source) {
        assert (source.remaining() > 0);
        this.buffer = source;
    }

    private ByteBufferView(ByteBuffer source, Void overload) {
        this(source);
        this.hashCode = Integer.MIN_VALUE;
    }

    public static ByteSequence view(ByteBuffer data) {
        ByteBuffer buffer = data.slice();
        return buffer.hasRemaining() ? new ByteBufferView(buffer, null) : ByteSequence.empty();
    }

    public static ByteSequence of(ByteBuffer data) {
        ByteBuffer buffer = data.slice();
        return buffer.hasRemaining() ? new ByteBufferView(buffer) : ByteSequence.empty();
    }

    @Override
    public String toString() {
        return ByteSequences.toString(this);
    }

    @Override
    public boolean equals(Object obj) {
        return ByteSequences.equals(this, obj);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == Integer.MIN_VALUE) {
            return ByteSequences.hashCode(this);
        }
        if (result == 0) {
            this.hashCode = result = ByteSequences.hashCode(this);
        }
        return result;
    }

    @Override
    public int length() {
        return this.buffer.remaining();
    }

    @Override
    public byte valueAt(int index) {
        return this.buffer.get(index);
    }

    @Override
    public ByteContainer copy(int from, int to) {
        return ByteContainer.of(this.buffer(from, to));
    }

    @Override
    public ByteSequence view(int from, int to) {
        return from == to ? ByteSequence.empty() : ByteBufferView.of(this.buffer(from, to));
    }

    @Override
    public byte[] array() {
        int length = this.length();
        byte[] result = new byte[length];
        this.buffer.duplicate().get(result);
        return result;
    }

    @Override
    public byte[] array(int from, int to) {
        int range = ByteSequences.length(from, to, this.length());
        if (range == 0) {
            return ByteSequence.empty().array();
        }
        ByteBuffer slice = this.buffer(from, to);
        byte[] result = new byte[range];
        slice.get(result);
        return result;
    }

    @Override
    public String string(Charset encoding) {
        return encoding.decode(this.buffer()).toString();
    }

    @Override
    public ByteBuffer buffer() {
        return this.buffer.asReadOnlyBuffer();
    }

    @Override
    public IntStream stream() {
        return IntStream.range(0, this.length()).map(this::valueAt);
    }

    private ByteBuffer buffer(int from, int to) {
        ByteBuffer result = this.buffer.duplicate();
        try {
            result.position(from).limit(to);
        }
        catch (IllegalArgumentException e) {
            throw Throwables.init(new IndexOutOfBoundsException(), e);
        }
        return result;
    }
}

