/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.containers.bytes;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.stream.IntStream;
import net.yetamine.lang.containers.bytes.ByteArrayView;
import net.yetamine.lang.containers.bytes.ByteSequence;
import net.yetamine.lang.containers.bytes.ByteSequences;

public final class ByteContainer
implements ByteSequence {
    private static final ByteContainer EMPTY = new ByteContainer(new byte[0]);
    private final byte[] array;
    private ByteBuffer buffer;
    private int hashCode;

    private ByteContainer(byte[] data) {
        assert (data != null);
        this.array = data;
    }

    public static ByteContainer empty() {
        return EMPTY;
    }

    public static ByteContainer secure(ByteSequence source) {
        return source instanceof ByteContainer ? (ByteContainer)source : ByteContainer.of(source.buffer());
    }

    public static ByteContainer from(int ... data) {
        if (data.length == 0) {
            return ByteContainer.empty();
        }
        byte[] result = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            result[i] = (byte)data[i];
        }
        return new ByteContainer(result);
    }

    public static ByteContainer of(byte ... data) {
        return data.length == 0 ? ByteContainer.empty() : new ByteContainer((byte[])data.clone());
    }

    public static ByteContainer of(byte[] data, int from, int to) {
        int length = ByteSequences.length(from, to, data.length);
        if (length == 0) {
            return ByteContainer.empty();
        }
        byte[] array = new byte[length];
        System.arraycopy(data, from, array, 0, length);
        return new ByteContainer(array);
    }

    public static ByteContainer of(ByteBuffer data) {
        int length = data.remaining();
        if (length == 0) {
            return ByteContainer.empty();
        }
        byte[] payload = new byte[length];
        data.get(payload);
        return new ByteContainer(payload);
    }

    @Override
    public String toString() {
        return ByteSequences.toString(this);
    }

    @Override
    public boolean equals(Object obj) {
        return ByteSequences.equals(this, obj);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = ByteSequences.hashCode(this);
        }
        return result;
    }

    public static ByteContainer sha1(ByteSequence sequence) {
        return new ByteContainer(ByteSequences.sha1(sequence));
    }

    public ByteContainer sha1() {
        return ByteContainer.sha1(this);
    }

    @Override
    public int length() {
        return this.array.length;
    }

    @Override
    public byte valueAt(int index) {
        return this.array[index];
    }

    @Override
    public ByteContainer copy(int from, int to) {
        return from == 0 && to == this.length() ? this : ByteContainer.of(this.array, from, to);
    }

    @Override
    public ByteSequence view(int from, int to) {
        return ByteArrayView.of(this.array, from, to);
    }

    @Override
    public byte[] array() {
        return this.array.length == 0 ? this.array : (byte[])this.array.clone();
    }

    @Override
    public byte[] array(int from, int to) {
        int length = ByteSequences.length(from, to, this.array.length);
        if (length == 0) {
            return ByteContainer.EMPTY.array;
        }
        byte[] result = new byte[length];
        System.arraycopy(this.array, 0, result, 0, length);
        return result;
    }

    @Override
    public String string(Charset encoding) {
        return new String(this.array, encoding);
    }

    @Override
    public ByteBuffer buffer() {
        ByteBuffer result = this.buffer;
        if (result == null) {
            this.buffer = result = ByteBuffer.wrap(this.array);
        }
        return result.asReadOnlyBuffer();
    }

    @Override
    public IntStream stream() {
        return IntStream.range(0, this.array.length).map(i -> this.array[i]);
    }
}

