/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.containers.bytes;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import net.yetamine.lang.closeables.SafeCloseable;
import net.yetamine.lang.containers.bytes.ByteArrayView;
import net.yetamine.lang.containers.bytes.ByteSequence;

public final class ByteSequenceBuilder
extends ByteArrayOutputStream
implements SafeCloseable,
WritableByteChannel {
    public ByteSequenceBuilder() {
    }

    public ByteSequenceBuilder(int size) {
        super(size);
    }

    public ByteSequence toByteSequence() {
        return ByteArrayView.of(this.toByteArray());
    }

    public ByteSequenceBuilder clear() {
        this.reset();
        return this;
    }

    public ByteSequenceBuilder append(ByteSequence seq) {
        return this.append(seq.buffer());
    }

    public ByteSequenceBuilder append(ByteBuffer src) {
        this.write(src);
        return this;
    }

    public ByteSequenceBuilder append(byte[] b) {
        this.write(b);
        return this;
    }

    public ByteSequenceBuilder append(byte[] b, int off, int len) {
        this.write(b, off, len);
        return this;
    }

    public ByteSequenceBuilder append(int b) {
        this.write(b);
        return this;
    }

    public ByteSequenceBuilder append(byte b) {
        return this.append((int)b);
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) {
        if (src.hasArray()) {
            int result = src.remaining();
            this.write(src.array(), src.arrayOffset(), src.remaining());
            return result;
        }
        int result = 0;
        ByteSequenceBuilder byteSequenceBuilder = this;
        synchronized (byteSequenceBuilder) {
            while (src.hasRemaining()) {
                this.write(src.get());
                ++result;
            }
        }
        return result;
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }
}

