/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.containers.bytes;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.yetamine.lang.containers.bytes.ByteSequence;

public final class ByteSequences {
    private ByteSequences() {
        throw new AssertionError();
    }

    public static boolean equals(ByteSequence that, Object obj) {
        if (that == obj) {
            return true;
        }
        if (obj instanceof ByteSequence) {
            ByteSequence o = (ByteSequence)obj;
            int length = that.length();
            if (length != o.length()) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                if (that.valueAt(i) == o.valueAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static int hashCode(ByteSequence that) {
        int result = 0;
        int length = that.length();
        for (int i = 0; i < length; ++i) {
            result = 31 * result + that.valueAt(i);
        }
        return result;
    }

    public static String toString(ByteSequence that) {
        StringBuilder result = new StringBuilder(that.length() * 2);
        that.stream().mapToObj(value -> String.format("%02x", (byte)value)).forEach(result::append);
        return result.toString();
    }

    public static int compare(ByteSequence that, ByteSequence some) {
        if (that == some) {
            return 0;
        }
        int length1 = that.length();
        int length2 = some.length();
        int lim = Math.min(length1, length2);
        for (int i = 0; i < lim; ++i) {
            int byte2;
            int byte1 = that.valueAt(i) & 0xFF;
            if (byte1 == (byte2 = some.valueAt(i) & 0xFF)) continue;
            return byte1 - byte2;
        }
        return length1 - length2;
    }

    public static byte[] sha1(ByteSequence sequence) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(sequence.buffer());
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    static int index(int index, boolean condition) {
        if (condition) {
            return index;
        }
        throw new IndexOutOfBoundsException("Index out of bounds: " + index);
    }

    static int length(int from, int to, int length) {
        if (from == 0 && to == 0) {
            return 0;
        }
        int result = ByteSequences.index(to, to <= length) - ByteSequences.index(from, from < length);
        if (result < 0) {
            String f = "Invalid index range: [%d; %d)";
            throw new IndexOutOfBoundsException(String.format("Invalid index range: [%d; %d)", from, to));
        }
        return result;
    }
}

