/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.containers.bytes;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import net.yetamine.lang.containers.bytes.ByteSequenceReader;

final class DefaultByteSequenceReader
extends ByteSequenceReader {
    private final ByteBuffer buffer;

    public DefaultByteSequenceReader(ByteBuffer storage) {
        this.buffer = Objects.requireNonNull(storage);
        this.buffer.mark();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int read(ByteBuffer dst) throws IOException {
        int remaining = this.buffer.remaining();
        if (remaining == 0) {
            return dst.hasRemaining() ? -1 : 0;
        }
        int limit = this.buffer.limit();
        int length = Math.min(remaining, dst.remaining());
        try {
            this.buffer.limit(length);
            dst.put(this.buffer);
        }
        finally {
            this.buffer.limit(limit);
        }
        return length;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.buffer.hasRemaining()) {
            return this.buffer.get();
        }
        return -1;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int result = Math.min(this.buffer.remaining(), len);
        this.buffer.get(b, off, result);
        return result;
    }

    @Override
    public synchronized int available() {
        return this.buffer.remaining();
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (this.buffer != null) {
            this.buffer.mark();
        }
    }

    @Override
    public synchronized long skip(long n) {
        if (n <= 0L) {
            return 0L;
        }
        int result = Math.min((int)Math.min(n, Integer.MAX_VALUE), this.buffer.remaining());
        this.buffer.position(this.buffer.position() + result);
        return result;
    }

    @Override
    public synchronized void reset() {
        this.buffer.reset();
    }
}

