/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.containers.tuples;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.yetamine.lang.collections.Iterators;
import net.yetamine.lang.containers.tuples.Tuple;
import net.yetamine.lang.containers.tuples.Tuple3;

public final class Tuple2<T1, T2>
implements Tuple {
    private static final Tuple2<?, ?> EMPTY = new Tuple2<Object, Object>(null, null);
    private final T1 value1;
    private final T2 value2;

    private Tuple2(T1 t1, T2 t2) {
        this.value1 = t1;
        this.value2 = t2;
    }

    public static <T1, T2> Tuple2<T1, T2> tuple2(T1 t1, T2 t2) {
        return Tuple2.of(t1, t2);
    }

    public static <T1, T2> Tuple2<T1, T2> of(T1 t1, T2 t2) {
        return new Tuple2<T1, T2>(t1, t2);
    }

    public static <T1, T2> Tuple2<T1, T2> empty() {
        return EMPTY;
    }

    public static <T1, T2> Tuple2<T1, T2> narrow(Tuple2<? extends T1, ? extends T2> instance) {
        return instance;
    }

    public String toString() {
        return String.format("(%s, %s)", this.value1, this.value2);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Tuple2) {
            Tuple2 o = (Tuple2)obj;
            return Objects.equals(this.value1, o.value1) && Objects.equals(this.value2, o.value2);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.value1, this.value2);
    }

    @Override
    public int arity() {
        return 2;
    }

    @Override
    public Object get(int index) {
        switch (index) {
            case 0: {
                return this.get1();
            }
            case 1: {
                return this.get2();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public List<?> toList() {
        return Collections.unmodifiableList(Arrays.asList(this.value1, this.value2));
    }

    public T1 get1() {
        return this.value1;
    }

    public T2 get2() {
        return this.value2;
    }

    public <V> Tuple2<V, T2> set1(V value) {
        return Tuple2.of(value, this.value2);
    }

    public <V> Tuple2<T1, V> set2(V value) {
        return Tuple2.of(this.value1, value);
    }

    public Tuple2<T2, T1> swap() {
        return this == EMPTY ? Tuple2.empty() : Tuple2.of(this.value2, this.value1);
    }

    public <V> Tuple3<V, T1, T2> prepend(V value) {
        return Tuple3.of(value, this.value1, this.value2);
    }

    public <V> Tuple3<T1, T2, V> append(V value) {
        return Tuple3.of(this.value1, this.value2, value);
    }

    public <V> Tuple3<T1, V, T2> insert(V value) {
        return Tuple3.of(this.value1, value, this.value2);
    }

    public <V> Tuple2<V, T2> map1(Function<? super T1, ? extends V> mapping) {
        return Tuple2.of(mapping.apply(this.value1), this.value2);
    }

    public <V> Tuple2<T1, V> map2(Function<? super T2, ? extends V> mapping) {
        return Tuple2.of(this.value1, mapping.apply(this.value2));
    }

    public Tuple2<T1, T2> use1(Consumer<? super T1> consumer) {
        consumer.accept(this.value1);
        return this;
    }

    public Tuple2<T1, T2> use2(Consumer<? super T2> consumer) {
        consumer.accept(this.value2);
        return this;
    }

    public Tuple2<T1, T2> use(BiConsumer<? super T1, ? super T2> consumer) {
        consumer.accept(this.value1, this.value2);
        return this;
    }

    public <V> V map(BiFunction<? super T1, ? super T2, ? extends V> mapping) {
        return mapping.apply(this.value1, this.value2);
    }

    public static <K, V> Tuple2<K, V> from(Map.Entry<? extends K, ? extends V> entry) {
        return Tuple2.of(entry.getKey(), entry.getValue());
    }

    public static <T> Tuple2<T, T> from(Iterable<? extends T> source) {
        return Tuple2.from(source.iterator());
    }

    public static <T> Tuple2<T, T> from(Iterator<? extends T> source) {
        return Tuple2.of(source.next(), source.next());
    }

    public static <T1, T2> Iterable<Tuple2<T1, T2>> zip(final Iterable<? extends T1> source1, final Iterable<? extends T2> source2) {
        Objects.requireNonNull(source1);
        Objects.requireNonNull(source2);
        return new Iterable<Tuple2<T1, T2>>(){

            @Override
            public Iterator<Tuple2<T1, T2>> iterator() {
                return Tuple2.zip(source1.iterator(), source2.iterator());
            }
        };
    }

    public static <T1, T2> Iterator<Tuple2<T1, T2>> zip(final Iterator<? extends T1> source1, final Iterator<? extends T2> source2) {
        Objects.requireNonNull(source1);
        Objects.requireNonNull(source2);
        return new Iterator<Tuple2<T1, T2>>(){

            @Override
            public boolean hasNext() {
                return source1.hasNext() && source2.hasNext();
            }

            @Override
            public Tuple2<T1, T2> next() {
                return Tuple2.of(source1.next(), source2.next());
            }
        };
    }

    public static <T1, T2> Stream<Tuple2<T1, T2>> zip(Stream<? extends T1> source1, Stream<? extends T2> source2) {
        return Iterators.stream(Tuple2.zip(source1.iterator(), source2.iterator()));
    }

    public Map<T1, T2> asMap() {
        return Collections.singletonMap(this.value1, this.value2);
    }

    public static <T1, T2> Collector<Tuple2<? extends T1, ? extends T2>, ?, Map<T1, T2>> toMap() {
        return Collectors.toMap(Tuple2::get1, Tuple2::get2);
    }
}

