/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.containers.tuples;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.yetamine.lang.collections.Iterators;
import net.yetamine.lang.containers.tuples.Tuple;
import net.yetamine.lang.containers.tuples.Tuple2;

public final class Tuple3<T1, T2, T3>
implements Tuple {
    private static final Tuple3<?, ?, ?> EMPTY = new Tuple3<Object, Object, Object>(null, null, null);
    private final T1 value1;
    private final T2 value2;
    private final T3 value3;

    private Tuple3(T1 t1, T2 t2, T3 t3) {
        this.value1 = t1;
        this.value2 = t2;
        this.value3 = t3;
    }

    public static <T1, T2, T3> Tuple3<T1, T2, T3> tuple3(T1 t1, T2 t2, T3 t3) {
        return Tuple3.of(t1, t2, t3);
    }

    public static <T1, T2, T3> Tuple3<T1, T2, T3> of(T1 t1, T2 t2, T3 t3) {
        return new Tuple3<T1, T2, T3>(t1, t2, t3);
    }

    public static <T1, T2, T3> Tuple3<T1, T2, T3> empty() {
        return EMPTY;
    }

    public static <T1, T2, T3> Tuple3<T1, T2, T3> narrow(Tuple3<? extends T1, ? extends T2, ? extends T3> instance) {
        return instance;
    }

    public String toString() {
        return String.format("(%s, %s, %s)", this.value1, this.value2, this.value3);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Tuple3) {
            Tuple3 o = (Tuple3)obj;
            return Objects.equals(this.value1, o.value1) && Objects.equals(this.value2, o.value2) && Objects.equals(this.value3, o.value3);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.value1, this.value2, this.value3);
    }

    @Override
    public int arity() {
        return 3;
    }

    @Override
    public Object get(int index) {
        switch (index) {
            case 0: {
                return this.get1();
            }
            case 1: {
                return this.get2();
            }
            case 2: {
                return this.get3();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public List<?> toList() {
        return Collections.unmodifiableList(Arrays.asList(this.value1, this.value2, this.value3));
    }

    public T1 get1() {
        return this.value1;
    }

    public T2 get2() {
        return this.value2;
    }

    public T3 get3() {
        return this.value3;
    }

    public <V> Tuple3<V, T2, T3> set1(V value) {
        return Tuple3.of(value, this.value2, this.value3);
    }

    public <V> Tuple3<T1, V, T3> set2(V value) {
        return Tuple3.of(this.value1, value, this.value3);
    }

    public <V> Tuple3<T1, T2, V> set3(V value) {
        return Tuple3.of(this.value1, this.value2, value);
    }

    public Tuple2<T1, T2> head() {
        return Tuple2.of(this.value1, this.value2);
    }

    public Tuple2<T2, T3> tail() {
        return Tuple2.of(this.value2, this.value3);
    }

    public Tuple2<T1, T3> outer() {
        return Tuple2.of(this.value1, this.value3);
    }

    public <V> Tuple3<V, T2, T3> map1(Function<? super T1, ? extends V> mapping) {
        return Tuple3.of(mapping.apply(this.value1), this.value2, this.value3);
    }

    public <V> Tuple3<T1, V, T3> map2(Function<? super T2, ? extends V> mapping) {
        return Tuple3.of(this.value1, mapping.apply(this.value2), this.value3);
    }

    public <V> Tuple3<T1, T2, V> map3(Function<? super T3, ? extends V> mapping) {
        return Tuple3.of(this.value1, this.value2, mapping.apply(this.value3));
    }

    public Tuple3<T1, T2, T3> use1(Consumer<? super T1> consumer) {
        consumer.accept(this.value1);
        return this;
    }

    public Tuple3<T1, T2, T3> use2(Consumer<? super T2> consumer) {
        consumer.accept(this.value2);
        return this;
    }

    public Tuple3<T1, T2, T3> use3(Consumer<? super T3> consumer) {
        consumer.accept(this.value3);
        return this;
    }

    public static <T> Tuple3<T, T, T> from(Iterable<? extends T> source) {
        return Tuple3.from(source.iterator());
    }

    public static <T> Tuple3<T, T, T> from(Iterator<? extends T> source) {
        return Tuple3.of(source.next(), source.next(), source.next());
    }

    public static <T1, T2, T3> Iterable<Tuple3<T1, T2, T3>> zip(final Iterable<? extends T1> source1, final Iterable<? extends T2> source2, final Iterable<? extends T3> source3) {
        Objects.requireNonNull(source1);
        Objects.requireNonNull(source2);
        Objects.requireNonNull(source3);
        return new Iterable<Tuple3<T1, T2, T3>>(){

            @Override
            public Iterator<Tuple3<T1, T2, T3>> iterator() {
                return Tuple3.zip(source1.iterator(), source2.iterator(), source3.iterator());
            }
        };
    }

    public static <T1, T2, T3> Iterator<Tuple3<T1, T2, T3>> zip(final Iterator<? extends T1> source1, final Iterator<? extends T2> source2, final Iterator<? extends T3> source3) {
        Objects.requireNonNull(source1);
        Objects.requireNonNull(source2);
        Objects.requireNonNull(source3);
        return new Iterator<Tuple3<T1, T2, T3>>(){

            @Override
            public boolean hasNext() {
                return source1.hasNext() && source2.hasNext() && source3.hasNext();
            }

            @Override
            public Tuple3<T1, T2, T3> next() {
                return Tuple3.of(source1.next(), source2.next(), source3.next());
            }
        };
    }

    public static <T1, T2, T3> Stream<Tuple3<T1, T2, T3>> zip(Stream<? extends T1> source1, Stream<? extends T2> source2, Stream<? extends T3> source3) {
        return Iterators.stream(Tuple3.zip(source1.iterator(), source2.iterator(), source3.iterator()));
    }
}

