/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.containers.values;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.yetamine.lang.containers.Pointer;
import net.yetamine.lang.containers.values.Value;

public final class Box<T>
implements Serializable,
Value<T>,
Pointer<T> {
    private static final long serialVersionUID = 1L;
    private T value;

    private Box() {
    }

    private Box(T initial) {
        this.value = initial;
    }

    public static <T> Box<T> of(T value) {
        return new Box<T>(value);
    }

    public static <T> Box<T> empty() {
        return new Box<T>();
    }

    public String toString() {
        return "box[" + this.value + ']';
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof Box && Objects.equals(((Box)obj).value, this.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    @Override
    public void accept(T t) {
        this.value = t;
    }

    @Override
    public T get() {
        return this.value;
    }

    public Box<T> set(T t) {
        this.value = t;
        return this;
    }

    public T put(T t) {
        T result = this.value;
        this.value = t;
        return result;
    }

    public T clear() {
        return this.put(null);
    }

    public Box<T> patch(Function<? super T, ? extends T> mapping) {
        this.value = mapping.apply(this.value);
        return this;
    }

    public Box<T> patch(BiFunction<? super T, ? super T, ? extends T> mapping, T t) {
        this.value = mapping.apply(t, this.value);
        return this;
    }

    @Override
    public Box<T> use(Consumer<? super T> consumer) {
        consumer.accept(this.value);
        return this;
    }
}

