/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.containers.values;

import java.util.Objects;
import java.util.function.Supplier;
import net.yetamine.lang.containers.values.Value;

public final class Deferred<T>
implements Value<T> {
    private final Supplier<? extends T> supplier;
    private volatile Supplier<? extends T> value;

    public Deferred(Supplier<? extends T> compute) {
        this.supplier = Objects.requireNonNull(compute);
    }

    public String toString() {
        return String.format("deferred[supplier=%s, value=%s]", this.supplier, this.value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        Object result;
        Supplier<T> guess = this.value;
        if (guess != null) {
            return guess.get();
        }
        Deferred deferred = this;
        synchronized (deferred) {
            Supplier<T> box = this.value;
            if (box != null) {
                return box.get();
            }
            result = this.supplier.get();
            this.value = () -> result;
        }
        return result;
    }

    @Override
    public void invalidate() {
        this.value = null;
    }
}

