/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.containers.values;

import java.util.Objects;
import net.yetamine.lang.containers.values.Value;

public final class Identical<T>
implements Value<T> {
    private static final Identical<Object> NIL = new Identical<Object>(null);
    private final T value;

    private Identical(T object) {
        this.value = object;
    }

    public static <T> Identical<T> of(T object) {
        return object != null ? new Identical<T>(object) : Identical.nil();
    }

    public static <T> Identical<T> nil() {
        return NIL;
    }

    public String toString() {
        return String.format("identical[id=%08x, value=%s]", System.identityHashCode(this.value), this.value);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Identical && ((Identical)obj).value == this.value;
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    @Override
    public T get() {
        return this.value;
    }
}

