/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.containers.values;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.yetamine.lang.containers.values.Value;

public final class Indirect<T>
implements Value<T> {
    private final Supplier<? extends T> supplier;
    private final Function<? super T, ? extends Supplier<? extends T>> factory;
    private volatile Supplier<? extends T> reference;

    public Indirect(Supplier<? extends T> compute, Function<? super T, ? extends Supplier<? extends T>> customize) {
        this.factory = Objects.requireNonNull(customize);
        this.supplier = Objects.requireNonNull(compute);
        this.invalidate();
    }

    public String toString() {
        return String.format("indirect[supplier=%s, factory=%s]", this.supplier, this.factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        T current = this.reference.get();
        if (current != null) {
            return current;
        }
        Indirect indirect = this;
        synchronized (indirect) {
            T retry = this.reference.get();
            if (retry != null) {
                return retry;
            }
            T result = this.supplier.get();
            this.reference = this.factory.apply(result);
            return result;
        }
    }

    @Override
    public void invalidate() {
        this.reference = () -> null;
    }
}

