/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.creational;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleProxies;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.function.Function;
import net.yetamine.lang.Types;
import net.yetamine.lang.creational.Factory;
import net.yetamine.lang.exceptions.Throwables;

public final class Cloneables {
    private static final MethodHandle HANDLE_CLONE_NOT_SUPPORTED;

    private Cloneables() {
        throw new AssertionError();
    }

    public static <T> T clone(T object) throws CloneNotSupportedException {
        return Cloneables.clone(object, e -> Throwables.init(new CloneNotSupportedException(), e));
    }

    public static <T, X extends Throwable> T clone(T object, Function<? super Throwable, ? extends X> exceptionMapping) throws X {
        Objects.requireNonNull(exceptionMapping);
        if (object == null) {
            return null;
        }
        Class<T> clazz = Types.classOf(object);
        if (clazz.isArray()) {
            return Cloneables.arrayClone(object);
        }
        try {
            return clazz.cast(clazz.getMethod("clone", new Class[0]).invoke(object, new Object[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Throwable toThrow = (Throwable)exceptionMapping.apply(e);
            if (toThrow != null) {
                throw toThrow;
            }
            return null;
        }
    }

    public static <T> Factory<T> prototype(T template) {
        Class<T> clazz = Types.classOf(template);
        if (clazz.isArray()) {
            return () -> Cloneables.arrayClone(template);
        }
        if (!(template instanceof Cloneable)) {
            throw new IllegalArgumentException("Cloneable object required.");
        }
        try {
            MethodHandle clone = MethodHandles.publicLookup().unreflect(clazz.getMethod("clone", new Class[0]));
            MethodHandle bound = clone.bindTo(template);
            MethodHandle never = MethodHandles.constant(clone.type().returnType(), null);
            MethodHandle catcher = MethodHandles.filterReturnValue(HANDLE_CLONE_NOT_SUPPORTED, never);
            MethodHandle handler = MethodHandles.catchException(bound, CloneNotSupportedException.class, catcher);
            Factory result = MethodHandleProxies.asInterfaceInstance(Factory.class, handler);
            return result;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new SecurityException(e);
        }
    }

    private static void handleCloneNotSupported(CloneNotSupportedException e) {
        throw new UnsupportedOperationException(e);
    }

    private static <T> T arrayClone(T array) {
        Class<T> clazz = Types.classOf(array);
        Class<?> component = clazz.getComponentType();
        int length = Array.getLength(array);
        Object result = Array.newInstance(component, length);
        System.arraycopy(array, 0, result, 0, length);
        return clazz.cast(result);
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodType type = MethodType.methodType(Void.TYPE, CloneNotSupportedException.class);
            HANDLE_CLONE_NOT_SUPPORTED = lookup.findStatic(Cloneables.class, "handleCloneNotSupported", type);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

