/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.creational;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Objects;
import net.yetamine.lang.containers.bytes.ByteSequence;
import net.yetamine.lang.containers.bytes.ByteSequenceBuilder;
import net.yetamine.lang.creational.Factory;

public final class Serialized<T>
implements Factory<T> {
    private final ByteSequence data;

    public Serialized(T source) {
        Objects.requireNonNull(source);
        ByteSequenceBuilder builder = ByteSequence.builder();
        try (ObjectOutputStream os = new ObjectOutputStream(builder);){
            os.writeObject(source);
        }
        catch (IOException e) {
            throw new UnsupportedOperationException(e);
        }
        this.data = builder.toByteSequence();
        assert (this.build() != null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T build() {
        try (ObjectInputStream is = new ObjectInputStream(this.data.reader());){
            Object result = is.readObject();
            assert (result != null);
            Object object = result;
            return (T)object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

