/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.exceptions;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.yetamine.lang.exceptions.ThrowingConsumer;
import net.yetamine.lang.exceptions.ThrowingOperation;
import net.yetamine.lang.exceptions.ThrowingRunnable;

public final class Throwing<T extends Throwable> {
    private static final Throwing<?> NONE = new Throwing<Object>(null);
    private final T throwable;

    private Throwing(T t) {
        this.throwable = t;
    }

    public static <T extends Throwable> Throwing<T> narrow(Throwing<? extends T> instance) {
        return instance;
    }

    public static Throwing<Throwable> sandbox(ThrowingRunnable<?> operation) {
        Objects.requireNonNull(operation);
        try {
            operation.run();
        }
        catch (Throwable t) {
            return Throwing.some(t);
        }
        return Throwing.none();
    }

    public static Throwing<Exception> guard(ThrowingRunnable<?> operation) {
        Objects.requireNonNull(operation);
        try {
            operation.run();
        }
        catch (Exception e) {
            return Throwing.some(e);
        }
        return Throwing.none();
    }

    public static <T extends Throwable> Throwing<T> some(T throwable) {
        return new Throwing<T>(Objects.requireNonNull(throwable));
    }

    public static <T extends Throwable> Throwing<T> maybe(T throwable) {
        return throwable != null ? new Throwing<T>(throwable) : Throwing.none();
    }

    public static <T extends Throwable> Throwing<T> none() {
        return NONE;
    }

    public static Throwing<Throwable> cause(Throwable throwable) {
        return Throwing.maybe(throwable.getCause());
    }

    public Throwing<Throwable> cause() {
        return this.throwable != null ? Throwing.maybe(((Throwable)this.throwable).getCause()) : Throwing.none();
    }

    public <X extends Throwable> Throwing<T> throwIf(Class<X> clazz, Predicate<? super X> condition) throws X {
        Throwable t;
        if (clazz.isInstance(this.throwable) && condition.test(t = (Throwable)clazz.cast(this.throwable))) {
            throw t;
        }
        assert (condition != null);
        return this;
    }

    public <X extends Throwable> Throwing<T> throwIf(Class<X> clazz) throws X {
        if (clazz.isInstance(this.throwable)) {
            throw (Throwable)clazz.cast(this.throwable);
        }
        return this;
    }

    public Throwing<T> throwIfUnchecked() {
        return this.throwIf(RuntimeException.class).throwIf(Error.class);
    }

    public <X extends Throwable> Throwing<T> throwAs(Function<? super T, X> mapping) throws X {
        Throwable t = (Throwable)mapping.apply(this.throwable);
        if (t != null) {
            throw t;
        }
        return this;
    }

    public <X extends Throwable, Z extends Throwable> Throwing<T> throwAs(Function<? super X, ? extends Z> mapping, Class<X> clazz) throws Z {
        Throwable t;
        if (clazz.isInstance(this.throwable) && (t = (Throwable)mapping.apply(clazz.cast(this.throwable))) != null) {
            throw t;
        }
        return this;
    }

    public <X extends Throwable> Throwing<X> map(Function<? super T, ? extends X> mapping) {
        return this.throwable != null ? Throwing.maybe((Throwable)mapping.apply(this.throwable)) : Throwing.none();
    }

    public <Q extends Throwable, X extends Exception> Throwing<T> when(Class<? extends Q> type, ThrowingConsumer<Q, X> handler) throws X {
        if (type.isInstance(this.throwable)) {
            handler.accept(type.cast(this.throwable));
        }
        return this;
    }

    public <X extends Exception> Throwing<T> when(Class<? extends Throwable> type, ThrowingRunnable<X> handler) throws X {
        if (type.isInstance(this.throwable)) {
            handler.run();
        }
        return this;
    }

    public <X extends Exception> Throwing<T> then(ThrowingConsumer<? super T, X> handler) throws X {
        if (this.throwable != null) {
            handler.accept(this.throwable);
        }
        return this;
    }

    public <X extends Exception> Throwing<T> anyway(ThrowingRunnable<X> action) throws X {
        try {
            action.run();
        }
        catch (Throwable t) {
            if (this.throwable != null) {
                t.addSuppressed((Throwable)this.throwable);
            }
            throw t;
        }
        return this;
    }

    public <X extends Exception> Throwing<T> otherwise(ThrowingRunnable<X> action) throws X {
        if (this.throwable == null) {
            action.run();
        }
        return this;
    }

    public <R, X extends Exception> R yield(ThrowingOperation<? super T, ? extends R, X> operation) throws X {
        try {
            return operation.execute(this.throwable);
        }
        catch (Throwable t) {
            if (this.throwable != null) {
                t.addSuppressed((Throwable)this.throwable);
            }
            throw t;
        }
    }

    public Throwing<T> rethrow() throws T {
        if (this.throwable != null) {
            throw this.throwable;
        }
        return this;
    }

    public Optional<T> throwable() {
        return Optional.ofNullable(this.throwable);
    }

    public boolean couldThrow() {
        return this.throwable != null;
    }
}

