/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.exceptions;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import net.yetamine.lang.exceptions.ThrowingConsumer;
import net.yetamine.lang.exceptions.UncheckedException;

@FunctionalInterface
public interface ThrowingCallable<V, X extends Exception>
extends Callable<V> {
    @Override
    public V call() throws X;

    default public ThrowingCallable<V, X> whenInterrupted(ThrowingConsumer<? super InterruptedException, ? extends X> handler) {
        Objects.requireNonNull(handler);
        ThrowingCallable<Object, X> result = () -> {
            try {
                return this.call();
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    handler.accept((InterruptedException)e);
                }
                throw e;
            }
        };
        return result;
    }

    public static <V, X extends Exception> ThrowingCallable<V, X> from(ThrowingCallable<? extends V, ? extends X> callable) {
        return callable;
    }

    public static <V> Supplier<V> rethrowing(ThrowingCallable<? extends V, ?> callable) {
        Objects.requireNonNull(callable);
        return () -> {
            try {
                return callable.call();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new UncheckedException(e);
            }
        };
    }

    public static <V> Supplier<V> enclosing(ThrowingCallable<? extends V, ?> callable) {
        Objects.requireNonNull(callable);
        return () -> {
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw new UncheckedException(e);
            }
        };
    }

    public static <V> Supplier<V> guarding(ThrowingCallable<? extends V, ?> callable) {
        Objects.requireNonNull(callable);
        return () -> {
            try {
                return callable.call();
            }
            catch (Throwable t) {
                throw new UncheckedException(t);
            }
        };
    }
}

