/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.exceptions;

import java.util.Objects;
import java.util.function.Consumer;
import net.yetamine.lang.exceptions.UncheckedException;

@FunctionalInterface
public interface ThrowingConsumer<T, X extends Exception> {
    public void accept(T var1) throws X;

    default public Consumer<T> guarded(ThrowingConsumer<? super Throwable, ? extends RuntimeException> handler) {
        return arg -> {
            try {
                this.accept(arg);
            }
            catch (Throwable t) {
                handler.accept(t);
            }
        };
    }

    public static <T, X extends Exception> ThrowingConsumer<T, X> from(ThrowingConsumer<? super T, ? extends X> consumer) {
        return consumer;
    }

    public static <T> Consumer<T> rethrowing(ThrowingConsumer<? super T, ?> consumer) {
        Objects.requireNonNull(consumer);
        return arg -> {
            try {
                consumer.accept(arg);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new UncheckedException(e);
            }
        };
    }

    public static <T> Consumer<T> enclosing(ThrowingConsumer<? super T, ?> consumer) {
        Objects.requireNonNull(consumer);
        return arg -> {
            try {
                consumer.accept(arg);
            }
            catch (Exception e) {
                throw new UncheckedException(e);
            }
        };
    }

    public static <T> Consumer<T> guarding(ThrowingConsumer<? super T, ?> consumer) {
        Objects.requireNonNull(consumer);
        return arg -> {
            try {
                consumer.accept(arg);
            }
            catch (Throwable t) {
                throw new UncheckedException(t);
            }
        };
    }
}

