/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.exceptions;

import java.util.Objects;
import java.util.function.Function;
import net.yetamine.lang.exceptions.ThrowingConsumer;
import net.yetamine.lang.exceptions.UncheckedException;

@FunctionalInterface
public interface ThrowingOperation<T, R, X extends Exception> {
    public R execute(T var1) throws X;

    default public ThrowingOperation<T, R, X> whenInterrupted(ThrowingConsumer<? super InterruptedException, ? extends X> handler) {
        Objects.requireNonNull(handler);
        return arg -> {
            try {
                return this.execute(arg);
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    handler.accept((InterruptedException)e);
                }
                throw e;
            }
        };
    }

    public static <T, R, X extends Exception> ThrowingOperation<T, R, X> from(ThrowingOperation<? super T, ? extends R, ? extends X> operation) {
        return operation;
    }

    public static <T, R> Function<T, R> rethrowing(ThrowingOperation<? super T, ? extends R, ?> operation) {
        Objects.requireNonNull(operation);
        return arg -> {
            try {
                return operation.execute(arg);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new UncheckedException(e);
            }
        };
    }

    public static <T, R> Function<T, R> enclosing(ThrowingOperation<? super T, ? extends R, ?> operation) {
        Objects.requireNonNull(operation);
        return arg -> {
            try {
                return operation.execute(arg);
            }
            catch (Exception e) {
                throw new UncheckedException(e);
            }
        };
    }

    public static <T, R> Function<T, R> guarding(ThrowingOperation<? super T, ? extends R, ?> operation) {
        Objects.requireNonNull(operation);
        return arg -> {
            try {
                return operation.execute(arg);
            }
            catch (Throwable t) {
                throw new UncheckedException(t);
            }
        };
    }
}

