/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.exceptions;

import java.util.Objects;
import net.yetamine.lang.exceptions.ThrowingConsumer;
import net.yetamine.lang.exceptions.UncheckedException;

@FunctionalInterface
public interface ThrowingRunnable<X extends Exception> {
    public void run() throws X;

    default public Runnable guarded(ThrowingConsumer<? super Throwable, ? extends RuntimeException> handler) {
        return () -> {
            try {
                this.run();
            }
            catch (Throwable t) {
                handler.accept(t);
            }
        };
    }

    public static <X extends Exception> ThrowingRunnable<X> from(ThrowingRunnable<? extends X> runnable) {
        return runnable;
    }

    public static <T> Runnable rethrowing(ThrowingRunnable<?> runnable) {
        Objects.requireNonNull(runnable);
        return () -> {
            try {
                runnable.run();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new UncheckedException(e);
            }
        };
    }

    public static <T> Runnable enclosing(ThrowingRunnable<?> runnable) {
        Objects.requireNonNull(runnable);
        return () -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                throw new UncheckedException(e);
            }
        };
    }

    public static <T> Runnable guarding(ThrowingRunnable<?> runnable) {
        Objects.requireNonNull(runnable);
        return () -> {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                throw new UncheckedException(t);
            }
        };
    }
}

