/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.formatting;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.yetamine.lang.formatting.ToString;

public final class Quoting
implements Function<Object, String> {
    private final String opening;
    private final String closing;
    private final Supplier<String> missing;
    private final Function<? super String, String> escape;

    private Quoting(String open, String close, Supplier<String> none, Function<? super String, String> escaping) {
        this.closing = close;
        this.opening = open;
        this.missing = none;
        this.escape = escaping;
        assert (this.opening != null);
        assert (this.closing != null);
        assert (this.missing != null);
        assert (this.escape != null);
    }

    public static Quoting simple(String quote, String none) {
        Objects.requireNonNull(quote);
        return new Quoting(quote, quote, () -> none, Function.identity());
    }

    public static Quoting with(String quote) {
        return Quoting.simple(quote, "null");
    }

    public static Quoting with(String opening, String closing) {
        Objects.requireNonNull(opening);
        Objects.requireNonNull(closing);
        return new Quoting(opening, closing, () -> "null", Function.identity());
    }

    public Quoting missing(String value) {
        return new Quoting(this.opening, this.closing, () -> value, this.escape);
    }

    public Quoting missing(Supplier<String> supplier) {
        return new Quoting(this.opening, this.closing, Objects.requireNonNull(supplier), this.escape);
    }

    public Quoting escape(Function<? super String, String> escaping) {
        return new Quoting(this.opening, this.closing, this.missing, Objects.requireNonNull(escaping));
    }

    @Override
    public String apply(Object o) {
        if (o == null) {
            return this.missing.get();
        }
        return this.opening + this.escape.apply(o.toString()) + this.closing;
    }

    public ToString bind(Object o) {
        return new ToString(() -> this.apply(o));
    }

    public static String quote(Object o, String quote, String none) {
        return o != null ? Quoting.quote(o, quote) : none;
    }

    public static String quote(Object o, String quote, Supplier<String> none) {
        assert (none != null) : "Default value supplier must not be null.";
        return o != null ? Quoting.quote(o, quote) : none.get();
    }

    public static String quote(Object o, char quote, String none) {
        return o != null ? Quoting.quote(o, quote) : none;
    }

    public static String quote(Object o, char quote, Supplier<String> none) {
        assert (none != null) : "Default value supplier must not be null.";
        return o != null ? Quoting.quote(o, quote) : none.get();
    }

    public static String normal(Object o) {
        return Quoting.quote(o, '\"', "null");
    }

    public static String single(Object o) {
        return Quoting.quote(o, '\'', "null");
    }

    private static String quote(Object o, String quote) {
        String string = o.toString();
        int length = quote.length() * 2 + string.length();
        return new StringBuilder(length).append(quote).append(o).append(quote).toString();
    }

    private static String quote(Object o, char quote) {
        String string = o.toString();
        int length = 2 + string.length();
        return new StringBuilder(length).append(quote).append(o).append(quote).toString();
    }
}

