/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.functional;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.yetamine.lang.functional.NoOperation;

@FunctionalInterface
public interface Acceptor<T>
extends Consumer<T> {
    default public T apply(T t) {
        this.accept(t);
        return t;
    }

    @Override
    default public Acceptor<T> andThen(Consumer<? super T> after) {
        Objects.requireNonNull(after);
        return t -> {
            this.accept(t);
            after.accept(t);
        };
    }

    default public Acceptor<T> onlyIf(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return t -> {
            if (predicate.test(t)) {
                this.accept(t);
            }
        };
    }

    default public <V> Function<T, V> finish(Function<? super T, ? extends V> mapping) {
        Objects.requireNonNull(mapping);
        return t -> mapping.apply(this.apply(t));
    }

    public static <T> Acceptor<T> from(Consumer<? super T> consumer) {
        return consumer::accept;
    }

    public static <T> Acceptor<T> nil() {
        return NoOperation::execute;
    }

    public static <T> Acceptor<T> sequential(Iterable<? extends Consumer<? super T>> sequence) {
        Objects.requireNonNull(sequence);
        return t -> {
            for (Consumer consumer : sequence) {
                consumer.accept(t);
            }
        };
    }
}

