/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.functional;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import net.yetamine.lang.functional.NoOperation;

@FunctionalInterface
public interface BiAcceptor<T, U>
extends BiConsumer<T, U> {
    @Override
    default public BiAcceptor<T, U> andThen(BiConsumer<? super T, ? super U> after) {
        Objects.requireNonNull(after);
        return (t, u) -> {
            this.accept(t, u);
            after.accept(t, u);
        };
    }

    default public BiAcceptor<T, U> onlyIf(BiPredicate<? super T, ? super U> predicate) {
        Objects.requireNonNull(predicate);
        return (t, u) -> {
            if (predicate.test(t, u)) {
                this.accept(t, u);
            }
        };
    }

    public static <T, U> BiAcceptor<T, U> from(BiConsumer<? super T, ? super U> consumer) {
        return consumer::accept;
    }

    public static <T, U> BiAcceptor<T, U> nil() {
        return NoOperation::execute;
    }

    public static <T, U> BiAcceptor<T, U> sequential(Iterable<? extends BiConsumer<? super T, ? super U>> sequence) {
        Objects.requireNonNull(sequence);
        return (t, u) -> {
            for (BiConsumer consumer : sequence) {
                consumer.accept(t, u);
            }
        };
    }
}

