/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.functional;

import java.util.Objects;
import java.util.function.BiPredicate;

public final class BiPredicates {
    private BiPredicates() {
        throw new AssertionError();
    }

    public static <T, U> BiPredicate<T, U> from(BiPredicate<? super T, ? super U> predicate) {
        return predicate;
    }

    public static <T, U> BiPredicate<T, U> alwaysFalse() {
        return (t, u) -> false;
    }

    public static <T, U> BiPredicate<T, U> alwaysTrue() {
        return (t, u) -> true;
    }

    public static <T, U> BiPredicate<T, U> allOf(Iterable<? extends BiPredicate<? super T, ? super U>> sequence) {
        Objects.requireNonNull(sequence);
        return (t, u) -> {
            for (BiPredicate predicate : sequence) {
                if (predicate.test(t, u)) continue;
                return false;
            }
            return true;
        };
    }

    public static <T, U> BiPredicate<T, U> noneOf(Iterable<? extends BiPredicate<? super T, ? super U>> sequence) {
        Objects.requireNonNull(sequence);
        return (t, u) -> {
            for (BiPredicate predicate : sequence) {
                if (!predicate.test(t, u)) continue;
                return false;
            }
            return true;
        };
    }

    public static <T, U> BiPredicate<T, U> anyOf(Iterable<? extends BiPredicate<? super T, ? super U>> sequence) {
        Objects.requireNonNull(sequence);
        return (t, u) -> {
            for (BiPredicate predicate : sequence) {
                if (!predicate.test(t, u)) continue;
                return true;
            }
            return false;
        };
    }
}

