/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.functional;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.yetamine.lang.exceptions.ThrowingOperation;

@Deprecated
public final class Choice<T>
implements Supplier<T> {
    private static final Choice<?> RIGHT_NULL = new Choice<Object>(null, true);
    private static final Choice<?> WRONG_NULL = new Choice<Object>(null, false);
    private final T value;
    private final boolean right;

    private Choice(T o, boolean t) {
        this.value = o;
        this.right = t;
    }

    public static <T> Choice<T> narrow(Choice<? extends T> instance) {
        return instance;
    }

    public static <T> Choice<T> of(T value, boolean right) {
        return right ? Choice.right(value) : Choice.wrong(value);
    }

    public static <T> Choice<T> rightNull() {
        return RIGHT_NULL;
    }

    public static <T> Choice<T> wrongNull() {
        return WRONG_NULL;
    }

    public static <T> Choice<T> right(T o) {
        return o != null ? new Choice<T>(o, true) : Choice.rightNull();
    }

    public static <T> Choice<T> wrong(T o) {
        return o != null ? new Choice<T>(o, false) : Choice.wrongNull();
    }

    public static <T> Choice<T> nonNull(T o) {
        return o != null ? new Choice<T>(o, true) : Choice.wrongNull();
    }

    public static <T> Choice<T> from(Optional<? extends T> optional) {
        return Choice.narrow(optional.map(Choice::right).orElseGet(Choice::wrongNull));
    }

    public String toString() {
        return String.format("%s[%s]", this.right ? "Choice.right" : "Choice.wrong", this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Choice) {
            Choice o = (Choice)obj;
            return Objects.equals(this.value, o.value) && this.right == o.right;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.value, this.right);
    }

    @Override
    public T get() {
        return this.value;
    }

    public T require() {
        if (this.isRight()) {
            return this.value;
        }
        throw new NoSuchElementException();
    }

    public <X extends Throwable> T require(Supplier<? extends X> e) throws X {
        if (this.isRight()) {
            return this.value;
        }
        throw (Throwable)e.get();
    }

    public Stream<Choice<T>> stream() {
        return Stream.of(this);
    }

    public Optional<T> optional() {
        return this.isRight() ? Optional.ofNullable(this.value) : Optional.empty();
    }

    public Choice<T> right() {
        return this.isRight() ? this : Choice.right(this.value);
    }

    public Choice<T> wrong() {
        return this.isWrong() ? this : Choice.wrong(this.value);
    }

    public Choice<T> swap() {
        return this.isRight() ? Choice.wrong(this.value) : Choice.right(this.value);
    }

    public boolean isRight() {
        return this.right;
    }

    public boolean isWrong() {
        return !this.isRight();
    }

    public Choice<T> ifRight(Consumer<? super T> consumer) {
        if (this.isRight()) {
            consumer.accept(this.value);
        }
        return this;
    }

    public Choice<T> ifWrong(Consumer<? super T> consumer) {
        if (this.isWrong()) {
            consumer.accept(this.value);
        }
        return this;
    }

    public Choice<T> mapRight(Function<? super T, ? extends T> mapping) {
        return this.isRight() ? Choice.right(mapping.apply(this.value)) : this;
    }

    public Choice<T> mapWrong(Function<? super T, ? extends T> mapping) {
        return this.isRight() ? this : Choice.wrong(mapping.apply(this.value));
    }

    public <V> Choice<V> map(Function<? super T, ? extends V> whenRight, Function<? super T, ? extends V> whenWrong) {
        return this.isRight() ? Choice.right(whenRight.apply(this.value)) : Choice.wrong(whenWrong.apply(this.value));
    }

    public <V> Choice<V> map(Function<? super Choice<T>, Choice<V>> mapping) {
        return mapping.apply(this);
    }

    public Choice<T> use(Consumer<? super T> whenRight, Consumer<? super T> whenWrong) {
        if (this.isRight()) {
            whenRight.accept(this.value);
        } else {
            whenWrong.accept(this.value);
        }
        return this;
    }

    public Choice<T> use(Consumer<? super T> consumer) {
        consumer.accept(this.value);
        return this;
    }

    public <V> V reconcile(Function<? super T, ? extends V> whenRight, Function<? super T, ? extends V> whenWrong) {
        return this.isRight() ? whenRight.apply(this.value) : whenWrong.apply(this.value);
    }

    public <V> V reconcile(Function<? super T, ? extends V> function) {
        return function.apply(this.value);
    }

    public <V, X extends Exception> V resolve(ThrowingOperation<? super T, ? extends V, ? extends X> whenRight, ThrowingOperation<? super T, ? extends V, ? extends X> whenWrong) throws X {
        return this.isRight() ? whenRight.execute(this.value) : whenWrong.execute(this.value);
    }

    public <V, X extends Exception> V resolve(ThrowingOperation<? super T, ? extends V, ? extends X> function) throws X {
        return function.execute(this.value);
    }
}

