/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.functional;

import java.util.Objects;
import java.util.function.Predicate;

public final class Predicates {
    private Predicates() {
        throw new AssertionError();
    }

    public static <T> Predicate<T> from(Predicate<? super T> predicate) {
        return predicate;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return t -> false;
    }

    public static <T> Predicate<T> alwaysTrue() {
        return t -> true;
    }

    public static <T> Predicate<T> allOf(Iterable<? extends Predicate<? super T>> sequence) {
        Objects.requireNonNull(sequence);
        return t -> {
            for (Predicate predicate : sequence) {
                if (predicate.test(t)) continue;
                return false;
            }
            return true;
        };
    }

    public static <T> Predicate<T> noneOf(Iterable<? extends Predicate<? super T>> sequence) {
        Objects.requireNonNull(sequence);
        return t -> {
            for (Predicate predicate : sequence) {
                if (!predicate.test(t)) continue;
                return false;
            }
            return true;
        };
    }

    public static <T> Predicate<T> anyOf(Iterable<? extends Predicate<? super T>> sequence) {
        Objects.requireNonNull(sequence);
        return t -> {
            for (Predicate predicate : sequence) {
                if (!predicate.test(t)) continue;
                return true;
            }
            return false;
        };
    }
}

