/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.functional;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

@FunctionalInterface
public interface Producer<T>
extends Supplier<T> {
    default public Optional<T> optional() {
        return Optional.ofNullable(this.get());
    }

    default public Stream<T> stream() {
        return Stream.of(this).map(Supplier::get);
    }

    default public <V> V map(Function<? super T, ? extends V> mapping) {
        return mapping.apply(this.get());
    }

    default public Optional<T> filter(Predicate<? super T> condition) {
        return this.optional().filter(condition);
    }

    default public void pass(Consumer<? super T> consumer) {
        consumer.accept(this.get());
    }

    public static <T> Producer<T> from(Supplier<? extends T> supplier) {
        return supplier::get;
    }

    public static <T> Producer<T> value(T value) {
        return () -> value;
    }
}

