/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.functional;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.yetamine.lang.Trivalent;
import net.yetamine.lang.formatting.Quoting;
import net.yetamine.lang.functional.Choice;

public final class Single<T>
implements Supplier<T> {
    private static final Single<?> NULL = new Single<Object>(null, Trivalent.FALSE);
    private static final Single<?> EMPTY = new Single<Object>(null, Trivalent.TRUE);
    private static final Single<?> NONE = new Single<Object>(null, Trivalent.UNKNOWN);
    private final T value;
    private final Trivalent single;

    private Single(T initial, Trivalent state) {
        assert (state != null);
        this.single = state;
        this.value = initial;
    }

    public static <T> Single<T> narrow(Single<? extends T> instance) {
        return instance;
    }

    public static <T> Single<T> single(T value) {
        return value != null ? new Single<T>(value, Trivalent.TRUE) : EMPTY;
    }

    public static <T> Single<T> some(T value) {
        return value != null ? new Single<T>(value, Trivalent.FALSE) : NULL;
    }

    public static <T> Single<T> none() {
        return NONE;
    }

    public String toString() {
        return String.format("single[%s, %s]", new Object[]{this.single, Quoting.single(this.value)});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof Single && Objects.equals(((Single)obj).value, this.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    @Override
    public T get() {
        return this.value;
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.single.isTrue()) {
            assert (exceptionSupplier != null) : "Exception supplier must not be null.";
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public Trivalent single() {
        return this.single;
    }

    public Choice<T> choice() {
        return Choice.of(this.value, this.single.isTrue());
    }

    public Optional<T> optional() {
        return this.single.isTrue() ? Optional.ofNullable(this.value) : Optional.empty();
    }

    public Stream<Single<T>> stream() {
        return Stream.of(this);
    }

    public Single<T> revised(T update) {
        return this.single.isUnknown() ? Single.single(update) : Single.some(update);
    }

    public Single<T> updated(T update) {
        switch (this.single) {
            case UNKNOWN: {
                return Single.single(update);
            }
            case FALSE: {
                return this;
            }
            case TRUE: {
                return Single.some(this.value);
            }
        }
        throw new AssertionError();
    }

    public Single<T> updated() {
        return this.single.isTrue() ? Single.some(this.value) : this;
    }

    public Single<T> merged(Single<? extends T> other) {
        Objects.requireNonNull(other);
        if (this.single.isFalse()) {
            return this;
        }
        if (this.single.isUnknown()) {
            Single<? extends T> result = other;
            return result;
        }
        return Single.some(this.value);
    }

    public static <T> Single<T> head(Iterator<? extends T> source) {
        if (source.hasNext()) {
            Single<T> result = Single.single(source.next());
            return source.hasNext() ? result.updated() : result;
        }
        return Single.none();
    }

    public static <T> Single<T> head(Iterable<? extends T> source) {
        return Single.head(source.iterator());
    }

    public static <T> Single<T> head(Stream<? extends T> source) {
        return Single.head(source.iterator());
    }

    public static <T> Single<T> last(Iterator<? extends T> source) {
        Single<T> result = Single.none();
        while (source.hasNext()) {
            result = result.revised(source.next());
        }
        return result;
    }

    public static <T> Single<T> last(Iterable<? extends T> source) {
        return Single.last(StreamSupport.stream(source.spliterator(), false));
    }

    public static <T> Single<T> last(List<? extends T> source) {
        ListIterator<T> it = source.listIterator(source.size());
        if (it.hasPrevious()) {
            Single<T> result = Single.single(it.previous());
            return it.hasPrevious() ? result.updated() : result;
        }
        return Single.none();
    }

    public static <T> Single<T> last(Stream<? extends T> source) {
        return source.collect(LastCollector.instance());
    }

    public static <T> BiFunction<Single<T>, T, Single<T>> optimum(Comparator<T> comparator) {
        Objects.requireNonNull(comparator);
        return (s, i) -> {
            if (s.single().isUnknown()) {
                return Single.single(i);
            }
            Object value = s.get();
            int compare = comparator.compare(value, i);
            if (compare < 0) {
                return Single.single(i);
            }
            return compare == 0 ? s.updated() : s;
        };
    }

    public static <T> Collector<T, ?, Single<T>> collector(BiFunction<? super Single<T>, ? super T, Single<T>> updater) {
        return new SingleCollector<T>(updater);
    }

    private static final class Box<T> {
        private T value;

        private Box(T initial) {
            this.value = initial;
        }

        public static <T> Box<T> of(T value) {
            return new Box<T>(value);
        }

        public T get() {
            return this.value;
        }

        public void set(T t) {
            this.value = t;
        }

        public Box<T> replace(Function<? super T, ? extends T> mapping) {
            this.value = mapping.apply(this.value);
            return this;
        }
    }

    private static final class LastCollector<T>
    implements Collector<T, Box<Single<T>>, Single<T>> {
        private static final Collector<Object, Box<Single<Object>>, Single<Object>> INSTANCE = new LastCollector<Object>();

        private LastCollector() {
        }

        public static <T> Collector<T, ?, Single<T>> instance() {
            return INSTANCE;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return EnumSet.of(Collector.Characteristics.CONCURRENT, Collector.Characteristics.UNORDERED);
        }

        @Override
        public Supplier<Box<Single<T>>> supplier() {
            return () -> Box.of(Single.none());
        }

        @Override
        public BiConsumer<Box<Single<T>>, T> accumulator() {
            return (box, value) -> box.replace(unique -> unique.revised(value));
        }

        @Override
        public BinaryOperator<Box<Single<T>>> combiner() {
            return (box1, box2) -> Box.of(((Single)box2.get()).merged((Single)box1.get()));
        }

        @Override
        public Function<Box<Single<T>>, Single<T>> finisher() {
            return Box::get;
        }
    }

    private static final class SingleCollector<T>
    implements Collector<T, Box<Single<T>>, Single<T>> {
        private final BiFunction<? super Single<T>, ? super T, Single<T>> accumulatorUpdate;

        public SingleCollector(BiFunction<? super Single<T>, ? super T, Single<T>> updater) {
            this.accumulatorUpdate = Objects.requireNonNull(updater);
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return EnumSet.of(Collector.Characteristics.CONCURRENT);
        }

        @Override
        public Supplier<Box<Single<T>>> supplier() {
            return () -> Box.of(Single.none());
        }

        @Override
        public BiConsumer<Box<Single<T>>, T> accumulator() {
            return (box, value) -> box.set(this.accumulatorUpdate.apply(box.get(), value));
        }

        @Override
        public BinaryOperator<Box<Single<T>>> combiner() {
            return (box1, box2) -> Box.of(((Single)box2.get()).merged((Single)box1.get()));
        }

        @Override
        public Function<Box<Single<T>>, Single<T>> finisher() {
            return Box::get;
        }
    }
}

