/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.functional;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

@FunctionalInterface
public interface Traversing<C, V>
extends Function<C, Optional<V>> {
    @Override
    public Optional<V> apply(C var1);

    default public <T> Traversing<C, T> map(Function<? super V, ? extends T> f) {
        Objects.requireNonNull(f);
        return t -> ((Optional)this.apply(t)).map(f);
    }

    public static <R, V> Traversing<R, V> of(Function<? super R, ? extends V> f) {
        Objects.requireNonNull(f);
        return t -> Optional.ofNullable(t).map(f);
    }
}

