/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.functional;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

@FunctionalInterface
public interface UnaryOperation<T>
extends UnaryOperator<T> {
    default public UnaryOperation<T> andNext(Function<? super T, ? extends T> after) {
        Objects.requireNonNull(after);
        return t -> after.apply((T)this.apply(t));
    }

    default public UnaryOperation<T> onlyIf(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return t -> predicate.test(t) ? this.apply(t) : t;
    }

    public static <T> UnaryOperation<T> from(Function<? super T, ? extends T> operator) {
        return operator::apply;
    }

    public static <T> UnaryOperation<T> identity() {
        return t -> t;
    }

    public static <T> UnaryOperation<T> sequential(Iterable<? extends Function<? super T, ? extends T>> sequence) {
        Objects.requireNonNull(sequence);
        return t -> {
            Object result = t;
            for (Function function : sequence) {
                result = function.apply(result);
            }
            return result;
        };
    }
}

