/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.lang.introspective;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.yetamine.lang.collections.Capture;
import net.yetamine.lang.introspective.Extensible;

public final class Extensions
implements Serializable {
    private static final Extensions EMPTY = new Extensions(Collections.emptySet());
    private final Set<?> known;
    private static final long serialVersionUID = 1L;

    Extensions(Set<?> extensions) {
        this.known = extensions;
    }

    public static Extensions empty() {
        return EMPTY;
    }

    public static Extensions list(Object extension) {
        return new Extensions(Collections.singleton(extension));
    }

    public static Extensions list(Object ... extensions) {
        return Extensions.from(Arrays.asList(extensions));
    }

    public static Extensions from(Collection<?> extensions) {
        Set<?> capture = Capture.set(extensions);
        return capture.isEmpty() ? Extensions.empty() : new Extensions(capture);
    }

    public static Extensions from(Stream<?> extensions) {
        Set values = extensions.collect(Collectors.toSet());
        return values.isEmpty() ? Extensions.empty() : new Extensions(Capture.frozen(values));
    }

    public static Extensions combined(Extensions ... extensions) {
        return Extensions.combined(Stream.of(extensions));
    }

    public static Extensions combined(Stream<Extensions> extensions) {
        Set values = extensions.flatMap(extension -> extension.known().stream()).collect(Collectors.toSet());
        return values.isEmpty() ? Extensions.empty() : new Extensions(Capture.frozen(values));
    }

    public static Extensions using(Set<?> extensions) {
        Set<?> set = Collections.unmodifiableSet(extensions);
        return new Extensions(set.getClass() == extensions.getClass() ? extensions : set);
    }

    public static Extensions of(Object o) {
        return Extensible.query(o).extensions();
    }

    public static Extensions of(Extensible o) {
        return o != null ? o.extensions() : Extensions.empty();
    }

    public Extensions with(Object more) {
        return Extensions.from(Stream.concat(this.known().stream(), Stream.of(more)));
    }

    public Extensions with(Object ... more) {
        return Extensions.from(Stream.concat(this.known().stream(), Stream.of(more)));
    }

    public String toString() {
        return this.known.toString();
    }

    public int hashCode() {
        return this.known.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Extensions && this.known.equals(((Extensions)obj).known);
    }

    public Set<?> known() {
        return this.known;
    }

    public boolean contains(Object extension) {
        return this.known.contains(extension);
    }

    public boolean notPresent(Object extension, Runnable fallback) {
        if (this.known.contains(extension)) {
            fallback.run();
            return false;
        }
        return true;
    }

    public boolean notMissing(Object extension, Runnable fallback) {
        if (this.known.contains(extension)) {
            return true;
        }
        fallback.run();
        return false;
    }

    public Extensions ifPresent(Object extension, Runnable action) {
        this.notPresent(extension, action);
        return this;
    }

    public Extensions ifMissing(Object extension, Runnable action) {
        this.notMissing(extension, action);
        return this;
    }

    public Extensions allPresent(Runnable action, Object ... extensions) {
        if (Stream.of(extensions).allMatch(this.known::contains)) {
            action.run();
        }
        return this;
    }

    public Extensions anyPresent(Runnable action, Object ... extensions) {
        if (Stream.of(extensions).anyMatch(this.known::contains)) {
            action.run();
        }
        return this;
    }

    public Extensions allMissing(Runnable action, Object ... extensions) {
        if (Stream.of(extensions).noneMatch(this.known::contains)) {
            action.run();
        }
        return this;
    }

    public Extensions anyMissing(Runnable action, Object ... extensions) {
        Stream.of(extensions).filter(e -> !this.known.contains(e)).findAny().ifPresent(e -> action.run());
        return this;
    }

    public <T> Optional<T> optional(T extension) {
        return this.known.contains(extension) ? Optional.of(extension) : Optional.empty();
    }

    private Object writeReplace() {
        return this == EMPTY ? new SerializationProxy() : new SerializationProxy(this.known);
    }

    private static final class SerializationProxy
    implements Serializable {
        private final Set<?> known;
        private static final long serialVersionUID = 1L;

        public SerializationProxy(Set<?> set) {
            assert (set != null);
            this.known = set;
        }

        public SerializationProxy() {
            this.known = null;
        }

        private Object readResolve() {
            return this.known != null ? new Extensions(this.known) : Extensions.empty();
        }
    }
}

