/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.module.oauth.connector;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import net.ymate.framework.commons.HttpClientHelper;
import net.ymate.framework.commons.IHttpResponse;
import net.ymate.framework.commons.ParamUtils;
import net.ymate.module.oauth.connector.IOAuthConnectProcessor;
import net.ymate.module.oauth.connector.OAuthConnectUser;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;

public abstract class AbstractOAuthConnectProcessor
implements IOAuthConnectProcessor {
    private static final Log _LOG = LogFactory.getLog(AbstractOAuthConnectProcessor.class);
    private String __clientParamName;
    private String __secretParamName;
    private String __openIdParamName;
    private String __errorFlag;
    private boolean __needRedirectUri;
    protected IOAuthConnectProcessor.ConnectInitCfg __initCfg;

    public AbstractOAuthConnectProcessor() {
        this(null, null, null);
    }

    public AbstractOAuthConnectProcessor(String openIdParamName) {
        this(null, null, openIdParamName);
    }

    public AbstractOAuthConnectProcessor(String clientParamName, String secretParamName, String openIdParamName) {
        this.__clientParamName = StringUtils.defaultIfBlank((String)clientParamName, (String)"client_id");
        this.__secretParamName = StringUtils.defaultIfBlank((String)secretParamName, (String)"client_secret");
        this.__openIdParamName = openIdParamName;
    }

    @Override
    public void init(IOAuthConnectProcessor.ConnectInitCfg initCfg) {
        this.__initCfg = initCfg;
    }

    protected void __doSetErrorFlag(String errorFlag) {
        this.__errorFlag = StringUtils.defaultIfBlank((String)errorFlag, (String)"error");
    }

    protected void __doSetNeedRedirectUri(boolean needRedirectUri) {
        this.__needRedirectUri = needRedirectUri;
    }

    protected String __doBuildAuthzUrl(String scope, String state, boolean code) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put(this.__clientParamName, this.__initCfg.getClientId());
        _params.put("redirect_uri", this.__initCfg.getRedirectUri());
        if (code) {
            _params.put("response_type", "code");
        }
        if (StringUtils.isNotBlank((String)scope)) {
            _params.put("scope", scope);
        }
        if (StringUtils.isNotBlank((String)state)) {
            _params.put("state", state);
        }
        return ParamUtils.buildQueryParamStr(_params, (boolean)true, (String)"UTF-8");
    }

    protected OAuthConnectUser __doGetAccessToken(String code, String tokenUrl) throws Exception {
        return this.__doGetAccessToken(code, tokenUrl, false);
    }

    protected OAuthConnectUser __doGetAccessToken(String code, String tokenUrl, boolean usePost) throws Exception {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put(this.__clientParamName, this.__initCfg.getClientId());
        _params.put(this.__secretParamName, this.__initCfg.getClientSecret());
        if (this.__needRedirectUri) {
            _params.put("redirect_uri", this.__initCfg.getRedirectUri());
        }
        _params.put("code", code);
        _params.put("grant_type", "authorization_code");
        IHttpResponse _response = null;
        _response = usePost ? HttpClientHelper.create().post(tokenUrl, _params, this.__doGetRequestHeaders()) : HttpClientHelper.create().get(tokenUrl, _params, this.__doGetRequestHeaders());
        JSONObject _result = this.__doParseConnectResponseBody(_response);
        if (_result != null) {
            return new OAuthConnectUser().setAccessToken(_result.getString("access_token")).setRefreshToken(_result.getString("refresh_token")).setExpiresIn(_result.getIntValue("expires_in")).setOpenId(StringUtils.isBlank((String)this.__openIdParamName) ? null : _result.getString(this.__openIdParamName)).setScope(_result.getString("scope"));
        }
        return null;
    }

    protected Header[] __doGetRequestHeaders() {
        return null;
    }

    protected JSONObject __doParseConnectResponseBody(IHttpResponse response) throws Exception {
        if (response != null) {
            if (response.getStatusCode() == 200) {
                JSONObject _result = JSON.parseObject((String)response.getContent());
                if (_result.containsKey((Object)this.__errorFlag)) {
                    throw new RuntimeException(_result.toJSONString());
                }
                return _result;
            }
            if (_LOG.isDebugEnabled()) {
                _LOG.debug((Object)("ResponseBody: " + response.toString()));
            }
        }
        return null;
    }
}

