/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.module.oauth.connector;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.ymate.framework.commons.ParamUtils;
import net.ymate.module.oauth.connector.OAuthConnectUser;
import net.ymate.platform.webmvc.context.WebContext;
import net.ymate.platform.webmvc.util.WebUtils;
import org.apache.commons.lang.StringUtils;

public interface IOAuthConnectProcessor {
    public void init(ConnectInitCfg var1);

    public String getAuthorizeUrl(String var1);

    public OAuthConnectUser getConnectUser(String var1) throws Exception;

    public static class ConnectInitCfg {
        private String name;
        private String clientId;
        private String clientSecret;
        private String redirectUri;
        private Map<String, String> attributes;

        public ConnectInitCfg(String name, String clientId, String clientSecret, String redirectUri, Map<String, String> attributes) {
            this.name = name;
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            this.redirectUri = redirectUri;
            this.attributes = attributes != null ? attributes : Collections.emptyMap();
        }

        public String getName() {
            return this.name;
        }

        public String getClientId() {
            return this.clientId;
        }

        public String getClientSecret() {
            return this.clientSecret;
        }

        public String getRedirectUri() {
            String _redirectUrl;
            if (StringUtils.isBlank((String)this.redirectUri)) {
                this.redirectUri = WebUtils.buildURL((HttpServletRequest)WebContext.getRequest(), (String)("/oauth2/connect/" + this.name + "/redirect"), (boolean)true);
            }
            if (StringUtils.isNotBlank((String)(_redirectUrl = WebContext.getRequest().getParameter("redirect_url")))) {
                HashMap<String, String> _params = new HashMap<String, String>();
                _params.put("redirect_url", _redirectUrl);
                return ParamUtils.appendQueryParamValue((String)this.redirectUri, _params, (boolean)true, (String)"UTF-8");
            }
            return this.redirectUri;
        }

        public String getAttribute(String attrKey) {
            return this.attributes.get(attrKey);
        }

        public Map<String, String> getAttributes() {
            return Collections.unmodifiableMap(this.attributes);
        }
    }
}

