/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.module.oauth.connector;

import java.util.HashMap;
import java.util.Map;
import net.ymate.module.oauth.connector.IOAuthConnectProcessor;
import net.ymate.module.oauth.connector.IOAuthConnector;
import net.ymate.module.oauth.connector.IOAuthConnectorModuleCfg;
import net.ymate.module.oauth.connector.annotation.OAuthConnectProcessor;
import net.ymate.module.oauth.connector.handle.OAuthConnectProcessorHandler;
import net.ymate.module.oauth.connector.impl.DefaultOAuthConnectorModuleCfg;
import net.ymate.platform.core.Version;
import net.ymate.platform.core.YMP;
import net.ymate.platform.core.beans.IBeanHandler;
import net.ymate.platform.core.module.IModule;
import net.ymate.platform.core.module.annotation.Module;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Module
public class OAuthConnector
implements IModule,
IOAuthConnector {
    private static final Log _LOG = LogFactory.getLog(OAuthConnector.class);
    public static final Version VERSION = new Version(1, 0, 1, OAuthConnector.class.getPackage().getImplementationVersion(), Version.VersionType.Release);
    private static volatile IOAuthConnector __instance;
    private YMP __owner;
    private IOAuthConnectorModuleCfg __moduleCfg;
    private boolean __inited;
    private Map<String, IOAuthConnectProcessor> __connectProcessors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IOAuthConnector get() {
        if (__instance == null) {
            Version version = VERSION;
            synchronized (version) {
                if (__instance == null) {
                    __instance = (IOAuthConnector)YMP.get().getModule(OAuthConnector.class);
                }
            }
        }
        return __instance;
    }

    public String getName() {
        return "module.oauth.connector";
    }

    public void init(YMP owner) throws Exception {
        if (!this.__inited) {
            _LOG.info((Object)("Initializing ymate-module-oauth-connector-" + VERSION));
            this.__owner = owner;
            this.__moduleCfg = new DefaultOAuthConnectorModuleCfg(owner);
            this.__owner.registerHandler(OAuthConnectProcessor.class, (IBeanHandler)new OAuthConnectProcessorHandler(this));
            this.__moduleCfg.getConnectCallbackHandler().init(this);
            this.__connectProcessors = new HashMap<String, IOAuthConnectProcessor>();
            this.__inited = true;
        }
    }

    @Override
    public boolean isInited() {
        return this.__inited;
    }

    @Override
    public void registerConnectProcessorHandler(String name, Class<? extends IOAuthConnectProcessor> targetClass) throws Exception {
        IOAuthConnectProcessor.ConnectInitCfg _initCfg;
        if (StringUtils.isNotBlank((String)name) && targetClass != null && (_initCfg = this.__moduleCfg.getConnectInitCfg(name)) != null) {
            _LOG.info((Object)("--> Initializing connect processor " + targetClass));
            IOAuthConnectProcessor _processor = targetClass.newInstance();
            _processor.init(_initCfg);
            this.__connectProcessors.put(name, _processor);
        }
    }

    @Override
    public IOAuthConnectProcessor getConnectProcessor(String name) {
        return this.__connectProcessors.get(name);
    }

    public void destroy() throws Exception {
        if (this.__inited) {
            this.__inited = false;
            this.__moduleCfg = null;
            this.__owner = null;
        }
    }

    @Override
    public YMP getOwner() {
        return this.__owner;
    }

    @Override
    public IOAuthConnectorModuleCfg getModuleCfg() {
        return this.__moduleCfg;
    }
}

