/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.module.oauth.connector.controller;

import net.ymate.framework.commons.ParamUtils;
import net.ymate.framework.webmvc.intercept.UserSessionStatusInterceptor;
import net.ymate.module.oauth.connector.IOAuthConnectProcessor;
import net.ymate.module.oauth.connector.OAuthConnectUser;
import net.ymate.module.oauth.connector.OAuthConnector;
import net.ymate.platform.core.beans.annotation.Before;
import net.ymate.platform.webmvc.annotation.Controller;
import net.ymate.platform.webmvc.annotation.PathVariable;
import net.ymate.platform.webmvc.annotation.RequestMapping;
import net.ymate.platform.webmvc.annotation.RequestParam;
import net.ymate.platform.webmvc.view.IView;
import net.ymate.platform.webmvc.view.View;
import org.apache.commons.lang.StringUtils;

@Controller
@RequestMapping(value="/oauth2/connect")
@Before(value={UserSessionStatusInterceptor.class})
public class OAuthConnectController {
    @RequestMapping(value="/{connectName}")
    public IView __connect(@PathVariable String connectName, @RequestParam String state) throws Exception {
        IOAuthConnectProcessor _processor = OAuthConnector.get().getConnectProcessor(connectName);
        if (_processor != null) {
            state = StringUtils.defaultIfBlank((String)state, (String)ParamUtils.createNonceStr());
            IView _view = OAuthConnector.get().getModuleCfg().getConnectCallbackHandler().connect(connectName, state);
            if (_view == null) {
                return View.redirectView((String)_processor.getAuthorizeUrl(state));
            }
            return _view;
        }
        return View.httpStatusView((int)400);
    }

    @RequestMapping(value="/{connectName}/redirect")
    public IView __redirect(@PathVariable String connectName, @RequestParam String code, @RequestParam String state) throws Exception {
        OAuthConnectUser _connectUser;
        IOAuthConnectProcessor _processor = OAuthConnector.get().getConnectProcessor(connectName);
        if (_processor != null && (_connectUser = _processor.getConnectUser(code)) != null && StringUtils.isNotBlank((String)_connectUser.getOpenId())) {
            return OAuthConnector.get().getModuleCfg().getConnectCallbackHandler().handle(connectName, _connectUser, state);
        }
        return View.httpStatusView((int)400);
    }
}

