/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.module.oauth.connector.impl;

import com.alibaba.fastjson.JSONObject;
import net.ymate.framework.commons.HttpClientHelper;
import net.ymate.framework.commons.IHttpResponse;
import net.ymate.module.oauth.connector.AbstractOAuthConnectProcessor;
import net.ymate.module.oauth.connector.OAuthConnectUser;
import net.ymate.module.oauth.connector.annotation.OAuthConnectProcessor;
import org.apache.commons.lang.StringUtils;

@OAuthConnectProcessor(value="baidu")
public class BaiduConnectProcessor
extends AbstractOAuthConnectProcessor {
    private static final String __CONNECT_URL = "https://openapi.baidu.com/oauth/2.0/authorize?";
    private static final String __TOKEN_URL = "https://openapi.baidu.com/oauth/2.0/token";
    private static final String __USERINFO_URL = "https://openapi.baidu.com/rest/2.0/passport/users/getLoggedInUser?access_token=";

    public BaiduConnectProcessor() {
        this.__doSetNeedRedirectUri(true);
    }

    @Override
    public String getAuthorizeUrl(String state) {
        return __CONNECT_URL + this.__doBuildAuthzUrl("basic", state, true);
    }

    @Override
    public OAuthConnectUser getConnectUser(String code) throws Exception {
        IHttpResponse _response;
        JSONObject _result;
        OAuthConnectUser _connectUser = this.__doGetAccessToken(code, __TOKEN_URL);
        if (_connectUser != null && StringUtils.isNotBlank((String)_connectUser.getAccessToken()) && (_result = this.__doParseConnectResponseBody(_response = HttpClientHelper.create().get(__USERINFO_URL.concat(_connectUser.getAccessToken()), this.__doGetRequestHeaders()))) != null) {
            _connectUser.setOpenId(_result.getString("uid")).setNickName(_result.getString("uname")).setPhotoUrl(_result.getString("portrait"));
            String _photoUrl = _result.getString("portrait");
            if (StringUtils.isNotBlank((String)_photoUrl)) {
                _connectUser.setPhotoUrl("http://tb.himg.baidu.com/sys/portrait/item/" + _photoUrl);
            }
            _connectUser.setGender(OAuthConnectUser.Gender.UNKNOW);
        }
        return _connectUser;
    }
}

