/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.module.oauth.connector.impl;

import com.alibaba.fastjson.JSONObject;
import net.ymate.module.oauth.connector.IOAuthConnectCallbackHandler;
import net.ymate.module.oauth.connector.IOAuthConnector;
import net.ymate.module.oauth.connector.OAuthConnectUser;
import net.ymate.platform.webmvc.IWebMvc;
import net.ymate.platform.webmvc.context.WebContext;
import net.ymate.platform.webmvc.util.CookieHelper;
import net.ymate.platform.webmvc.view.IView;
import net.ymate.platform.webmvc.view.View;
import net.ymate.platform.webmvc.view.impl.HttpStatusView;
import org.apache.commons.codec.digest.DigestUtils;

public class DefaultConnectCallbackHandler
implements IOAuthConnectCallbackHandler {
    private String __cookieName;

    @Override
    public void init(IOAuthConnector owner) {
        this.__cookieName = owner.getModuleCfg().getCacheNamePrefix() + "module.oauth.connector" + "_state";
    }

    @Override
    public IView connect(String connectName, String state) throws Exception {
        CookieHelper.bind((IWebMvc)WebContext.getContext().getOwner()).setCookie(this.__cookieName, this.__doEncryptState(connectName, state));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IView handle(String connectName, OAuthConnectUser connectUser, String state) throws Exception {
        CookieHelper _helper = CookieHelper.bind((IWebMvc)WebContext.getContext().getOwner());
        try {
            String _cookieState = _helper.getCookie(this.__cookieName).toStringValue();
            if (this.__doEncryptState(connectName, state).equals(_cookieState)) {
                IView iView = this.__doHandle(connectName, connectUser, state);
                return iView;
            }
            HttpStatusView httpStatusView = View.httpStatusView((int)400);
            return httpStatusView;
        }
        finally {
            _helper.removeCookie(this.__cookieName);
        }
    }

    protected IView __doHandle(String connectName, OAuthConnectUser connectUser, String state) throws Exception {
        JSONObject _json = new JSONObject();
        _json.put(connectName, (Object)connectUser);
        _json.put("state", (Object)state);
        _json.put("status", (Object)true);
        return View.jsonView((Object)_json);
    }

    protected String __doEncryptState(String connectName, String state) throws Exception {
        return DigestUtils.md5Hex((String)(connectName + "|" + state));
    }
}

